

// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif


#include "player.h"
#include "FrameData.h"
#include "FramePacket.h"
#include "KeysPacket.h"
#include "GameState.h"


void Player::Run()
{
    FramePacket framePacket;
    KeysPacket keysPacket;
    FrameData frameData;
    GameState gameState;

    uint8_t prevframe = 0;
    uint32_t timestep = 0;

    for (;;)
    {
	++timestep;
	++keysPacket.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
	SendPacket(keysPacket);
	ReceivePacket(framePacket);
	
	if (framePacket.frameno != ++prevframe)
	{
	    printf("lost %d frame(s)\n", framePacket.frameno - prevframe);
	    timestep += framePacket.frameno - prevframe;
	    prevframe = framePacket.frameno;
	}
	
	if (framePacket.ping != keysPacket.ping)
	{
	    printf("Latenz %d\n", keysPacket.ping - framePacket.ping);
	}
	
	frameData.initFromFramePacket(framePacket, timestep);
	keysPacket.clear();   // alle Tasten loslassen
#if 1
	gameState.predict(timestep);
	gameState.updateFromFrameData(frameData);
	gameState.getKeys(keysPacket);
#endif	
#if 0
	int min_dist = 0x7fffffff;
	int min_dx = 0;
	int min_dy = 0;
	if (frameData.ship_present)
	{
	    for (int i=0; i<frameData.nasteroids; ++i)
	    {   // nchstgelegenen Asteroiden suchen
		int dx = frameData.asteroids[i].x - frameData.ship_x;
		while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
		while (dx > 511) dx -= 1024;
		int dy = frameData.asteroids[i].y - frameData.ship_y;
		while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
		while (dy > 383) dy -= 768;
		int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
		switch (frameData.asteroids[i].sf)
		{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
		case 0:  // groer Asteroid
		    dist -= 40*40;
		    break;
		case 15: // mittlerer Asteroid
		    dist -= 20*20;
		    break;
		case 14: // kleiner Asteroid
		    dist -= 8*8;
		    break;
		}
		if (dist < min_dist)
		{
		    min_dist = dist;
		    min_dx = dx;
		    min_dy = dy;
		}
	    }
	    if (frameData.saucer_present)
	    {
		int dx = frameData.saucer_x - frameData.ship_x;
		while (dx < -512) dx += 1024;
		while (dx > 511) dx -= 1024;
		int dy = frameData.saucer_y - frameData.ship_y;
		while (dy < -384) dy += 768;
		while (dy > 383) dy -= 768;
		int dist = dx*dx+dy*dy;
		switch (frameData.saucer_size)
		{	// Abstand um den ungefhren Radius des UFOs korrigieren
		case 15: // groes UFO
		    dist -= 20*12;
		    break;
		case 14: // kleines UFO
		    dist -= 10*6;
		    break;
		}
		if (dist < min_dist)
		{
		    min_dist = dist;
		    min_dx = dx;
		    min_dy = dy;
		}
	    }
	    
	    // Schiff in Richtung auf das nchstgelegene Objekt drehen
	    // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
	    // ship_dx/y/0 und min_dx/y/0 berechnet
	    if (frameData.ship_dx * min_dy - frameData.ship_dy * min_dx > 0)
		keysPacket.left(true);
	    else
		keysPacket.right(true);
	    
	    if (min_dist < 27*27)  // Flucht, wenn Kollision unausweichlich
		keysPacket.hyperspace(true);
	    
	    if (min_dist > 400*400) // beschleunigen, wenn nichts in der Nhe
		keysPacket.thrust(true);
	    
	    if ((timestep & 1) == 0)  // Feuerknopf drcken, so schnell es geht
		keysPacket.fire(true);
	}
#endif
    }
}

void Player::ReceivePacket(FramePacket &packet)
{
    fd_set readfds, writefds, exceptfds;
    
    do
    {
	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
	FD_SET(sd, &readfds);
	FD_SET(sd, &exceptfds);
	select(sd+1, &readfds, &writefds, &exceptfds, NULL);
	int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
	if (bytes_received != sizeof packet)
	{
	    int err = WSAGetLastError();
	    fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
	    exit(1);
	}
	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
	FD_SET(sd, &readfds);
	timeval zero;
	zero.tv_sec = zero.tv_usec = 0;
	select(sd+1, &readfds, &writefds, &exceptfds, &zero);
    } while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
    sockaddr_in server;
    memset(&server, 0, sizeof server);
    server.sin_family = AF_INET;
    server.sin_port = htons(1979);
    server.sin_addr.s_addr = server_ip;
    if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
    {
#if defined(WINDOWS)
	int err = WSAGetLastError();
	if (err != WSAEWOULDBLOCK)
	{
	    fprintf(stderr, "Fehler %d bei sendto().\n", err);
	    exit(1);
	}
#else
	if (errno != EAGAIN)
	{
	    perror("Fehler bei sendto()");
	    exit(1);
	}
#endif
    }
}

