#include <stdio.h>
#include "FrameData.h"
#include "FramePacket.h"
#include "player.h"

void FrameData::initFromFramePacket(FramePacket &framePacket, uint32_t timestep_)
{
    unsigned short vector_ram[512];
    int dx, dy, sf, vx=0, vy=0, vz, vs=0;
    int v1x = 0;
    int v1y = 0;
    int shipdetect = 0;
    
    clear();
    timestep = timestep_;

    /* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
     Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
     Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
    for (int i=0; i<512; ++i)
	vector_ram[i] = (unsigned char)framePacket.vectorram[2*i] | (unsigned char)framePacket.vectorram[2*i+1] << 8;
    
    if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
	return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
    
    int pc = 1;
    while (pc < 512)
    {
	int op = vector_ram[pc] >> 12;
	switch (op)
	{
	case 0xa: // LABS
	    vy = vector_ram[pc] & 0x3ff;
	    vx = vector_ram[pc+1] & 0x3ff;
	    vs = vector_ram[pc+1] >> 12;
	    break;
	case 0xb: // HALT
	    if (pc > 300)
		printf("ASM HALT at pc=%d\n", pc);
	    return;
	case 0xc: // JSRL
	    switch (vector_ram[pc] & 0xfff)
	    {
	    case 0x8f3:
		asteroids[nasteroids++].set(vx, vy, 1, vs);
		break;
	    case 0x8ff:
		asteroids[nasteroids++].set(vx, vy, 2, vs);
		break;
	    case 0x90d:
		asteroids[nasteroids++].set(vx, vy, 3, vs);
		break;
	    case 0x91a:
		asteroids[nasteroids++].set(vx, vy, 4, vs);
		break;
	    case 0x929:
		saucer_present = true;
		saucer_x = vx;
		saucer_y = vy;
		saucer_size = vs;
		break;
		//			case 
	    default:
		//			    printf("ASM unknown JSRL 0x%03X\n", vector_ram[pc] & 0xfff);
		break;
	    }  
	    break;
	case 0xd: // RTSL
	    printf("ASM unexpected RTSL (pc=%d)\n", pc);
	    break;
	case 0xe: // JMPL
	    printf("ASM unexpected JMPL (pc=%d)\n", pc);
	    /*
	     pc = vector_ram[pc] & 0xfff;
	     break;
	     */
	    break;
	case 0xf: // SVEC
	    //			printf("ASM unexpected SVEC (pc=%d)\n", pc);
	    /*
	     dy = vector_ram[pc] & 0x300;
	     if ((vector_ram[pc] & 0x400) != 0)
	     dy = -dy;
	     dx = (vector_ram[pc] & 3) << 8;
	     if ((vector_ram[pc] & 4) != 0)
	     dx = -dx;
	     sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
	     vz = (vector_ram[pc] & 0xf0) >> 4;
	     */
	    break;
	default: // 0-9 LVEC
	    dy = vector_ram[pc] & 0x3ff;
	    if ((vector_ram[pc] & 0x400) != 0)
		dy = -dy;
	    dx = vector_ram[pc+1] & 0x3ff;
	    if ((vector_ram[pc+1] & 0x400) != 0)
		dx = -dx;
	    sf = op;
	    vz = vector_ram[pc+1] >> 12;
	    if (dx == 0 && dy == 0 && vz == 15)
	    {
		if (vz == 15)
		    shots[nshots++].set(vx, vy);
		else 
		    printf("ASM dark shoot %d\n", vz);
	    }
	    if (op == 6 && vz == 12 && dx != 0 && dy != 0)
	    {
		switch (shipdetect)
		{
		case 0:
		    v1x = dx;
		    v1y = dy;
		    ++shipdetect;
		    break;
		case 1:
		    ship_present = true;
		    ship_x = vx;
		    ship_y = vy;
		    ship_dx = v1x - dx;
		    ship_dy = v1y - dy;
		    ++shipdetect;
		    break;
		}
	    }
	    else if (shipdetect == 1)
		shipdetect = 0;
	    
	    break;
	}
	if (op <= 0xa)
	    ++pc;
	if (op != 0xe) // JMPL
	    ++pc;
    }   
    
}


void FrameAsteroid::set(int x, int y, int type, int sf)
{
    this->x = x;
    this->y = y;
    this->type = type;
    this->sf = sf;
}


void FrameShot::set(int x, int y)
{
    this->x = x;
    this->y = y;
}


void FrameData::clear()
{
    ship_present = false;
    saucer_present = false;
    nasteroids = 0;
    nshots = 0;
}

