// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.swing.RJButton;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

/**
 *  Editor for colors.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class ColorEditor
        extends AbstractBasicEditorProvider
        implements PropertyChangeListener
{
  private static final int IMAGE_WIDTH  = 48;
  private static final int IMAGE_HEIGHT = 16;

  /** The associated preference property. */
  private final SwingColorPreferenceProperty property;
  /** Button which starts a color chooser dialog. */
  private final JButton button;
  /** The locally changed color. */
  private Color color;

  /**
   * Constructor.
   * @param prop property to edit
   * @param l    locale to use
   */
  public ColorEditor(SwingColorPreferenceProperty prop, final Locale l)
  {
    this(prop, l, false);
  }
  /**
   * Constructor.
   * @param prop property to edit
   * @param l    locale to use
   * @param autoSave save the changed color immediately?
   */
  public ColorEditor(SwingColorPreferenceProperty prop, final Locale l, final boolean autoSave)
  {
    super(prop, l);
    this.property = prop;
    color = property.getValue();
    button = new RJButton("btChangeColor", createColoredIcon(color));
    button.setLocale(l);
    button.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        Color newColor = JColorChooser.showDialog(button, property.getName(l), color);
        if (newColor != null) {
          setColor(newColor);
          if (autoSave) {
            save();
          }
        }
      }
    });
    property.addValueChangeListener(this);
  }

  private void setColor(Color color)
  {
    this.color = color;
    button.setIcon(createColoredIcon(color));
  }

  static Icon createColoredIcon(Color color)
  {
    Image image = new BufferedImage(IMAGE_WIDTH, IMAGE_HEIGHT, BufferedImage.TYPE_INT_RGB);
    Graphics g = image.getGraphics();
    g.setColor(color);
    g.fillRect(0, 0, IMAGE_WIDTH, IMAGE_HEIGHT);
    return new ImageIcon(image);
  }

  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return button;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  public void reset()
  {
    setColor(property.getValue());
  }

  /**
   * Set the basic value from the editor.
   */
  public void save()
  {
    property.setValue(color);
  }

  /**
   * Called when the editor provider is no longer used.
   */
  public void goodBye()
  {
    property.removeValueChangeListener(this);
  }

  /**
   * This method gets called when a bound property is changed.
   *
   * @param evt A PropertyChangeEvent object describing the event source
   *            and the property that has changed.
   */

  public void propertyChange(PropertyChangeEvent evt)
  {
    if (color.equals(evt.getOldValue())) {
      setColor((Color)evt.getNewValue());
    }
  }
}
