// ============================================================================
// File:               $File$
//
// Project:
//
// Purpose:
//
// Author:             Rammi
//
// Copyright Notice:   (c) 1999-2006  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date: 2006-02-01 13:48:49 +0100 (Mi, 01 Feb 2006) $
//
// History:	       $Log$
//=============================================================================

package de.caff.util.debug;

/**
 *  A listener for any debug message in &quot;cooked&quot; form.
 *
 *  @see Debug
 *  @see DebugMessageCook
 *
 *  @author Rammi
 */
public interface CookedMessageDebugListener
        extends DebugConstants
{
  /**
   *  Receive a cooked message. Cooked message always end with a line feed.
   *  @param   msgType message type (one of {@link #TRACE},
   *                   {@link #MESSAGE}, {@link #WARNING}, {@link #ERROR},
   *                   {@link #FATAL}, {@link #LOG} oder {@link #ASSERT})
   *  @param   msg     the message
   *  @param   pos     file position
   */
  public void receiveCookedMessage(int msgType, String msg, String pos);
}
