// ====================================================================
// File:		State.java
//
// Project:
//
// Purpose:		State is an interface for states, especially
//                      in GUIs. It is similar to the Action interface
//                      of Swing.
//
// Author:		rammi
// Date: 		31.03.2002
// Time: 		09:27:34
// --------------------------------------------------------------------
// Copyright Notice:	(c) 2002 Rammi (rammi@caff.de)
//                      This code is in the public domain.
//                      Use at own risk.
//                      No guarantees given.
//
// Latest change:       $Date$
//
// History: 		$Log$
// ====================================================================
package de.caff.gimmicks.swing;

import javax.swing.*;
import java.beans.PropertyChangeListener;

/**
 *  State is an interface for states, especially in GUIs. It is similar
 *  to the Action interface of Swing.
 *
 *  @author  <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface State
        extends Action
{
  /** Property identifier for enable state. */
  public static final String ENABLE_PROPERTY        = "ENABLE";
  /** Property identifier for activation. */
  public static final String ACTIVATION_PROPERTY    = "ACTIVATION";
  /** Property name for active icon. */
  public static final String ACTIVE_ICON_PROPERTY   = "ACTIVE_ICON";
  /** Property name for inactive icon. */
  public static final String INACTIVE_ICON_PROPERTY = "INACTIVE_ICON";
  /** Property name for disabled icon. */
  public static final String DISABLED_ICON_PROPERTY = "DISABLED_ICON";
  /** Property name for label text. */
  public static final String LABEL_TEXT_PROPERTY    = "LABEL_TEXT";
  /** Property name for tooltip text property. */
  public static final String TOOLTIP_TEXT_PROPERTY  = "TOOLTIP_TEXT";

  /**
   *  Add a property change listener for a special property.
   *  @param property propert< identifier
   *  @param listener listener to add
   */
  public void addPropertyChangeListener(String property, PropertyChangeListener listener);

  /**
   *  Remove a property change listener for a special property.
   *  @param property propert< identifier
   *  @param listener listener to remove
   */
  public void removePropertyChangeListener(String property, PropertyChangeListener listener);

  /**
   *  Activate this state.
   *  @return <code>true</code> if the activation was possible,
   *          <code>false<code> otherwise
   */
  public boolean activate();

  /**
   *  Is this state activated?
   *  @return the answer
   */
  public boolean isActivated();
}
