// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.human;

import de.caff.i18n.swing.RJButton;
import de.caff.i18n.swing.RJLabel;
import de.caff.i18n.I18n;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 *  Dialog which appears when the server is busy otherwise.
 */
class ServerBusyDialog
        extends JDialog
{
  /** Message label. */
  private JLabel message;
  /** Time to wait label. */
  private JLabel timeToWait;
  /** The number of seconds to wait. */
  private int secondsToWait;

  /**
   *  Constructor.
   *  @param client used for access to {@link de.caff.asteroid.human.HumanClient#exit(int)}
   */
  ServerBusyDialog(final HumanClient client)
  {
    super(client, true);
    setTitle(I18n.getString("diaServerBusy"));

    Box box = Box.createVerticalBox();
    box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(),
                                                     BorderFactory.createEmptyBorder(NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH,
                                                                                     NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH)));
    getContentPane().add(box, BorderLayout.CENTER);
    box.add(message = new RJLabel("lbServerBusy", JLabel.CENTER));
    message.setFont(message.getFont().deriveFont(NewGameDialog.FONT_SIZE));
    box.add(Box.createVerticalStrut(NewGameDialog.BORDER_WIDTH));
    box.add(timeToWait = new JLabel("00:00", JLabel.CENTER));
    timeToWait.setFont(timeToWait.getFont().deriveFont(NewGameDialog.FONT_SIZE));
    new Thread(new Runnable() {
      public void run()
      {
        while (true) {
          try {
            Thread.sleep(1000);
          } catch (InterruptedException e) {
          }
          synchronized (timeToWait) {
            int stw = getSecondsToWait();
            if (stw > 0) {
              refreshTimeToWait(stw - 1);
            }
          }
        }
      }
    }, "TTW Updater").start();

    JButton button = new RJButton("btEndGame");
    Box bbox = Box.createHorizontalBox();
    bbox.add(Box.createHorizontalGlue());
    bbox.add(button);
    bbox.add(Box.createHorizontalGlue());
    bbox.setBorder(BorderFactory.createEmptyBorder(NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH,
                                                   NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH));
    getContentPane().add(bbox, BorderLayout.SOUTH);

    button.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        client.exit(0);
      }
    });

    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    pack();
    setLocationRelativeTo(client);
  }


  void refreshTimeToWait(int seconds)
  {
    synchronized (timeToWait) {
      secondsToWait = seconds;
      timeToWait.setText(String.format("%02d:%02d", seconds/60, seconds%60));
    }
  }

  private synchronized int getSecondsToWait()
  {
    synchronized (timeToWait) {
      return secondsToWait;
    }
  }

  void setMessage(String msg)
  {
    message.setText(msg);
  }
}
