/*
created: Jun 16, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import java.io.IOException;

import static asteroids.AsteroidsConstants.*;
import asteroids.behaviours.*;
import asteroids.gui.*;
import de.caff.asteroid.FrameListener;
import de.heise.anniversary.contest.asteroids.*;



public class AsteroidsPlayer implements GameWorld
{
  private ServerConnection con;
  private boolean started;
  private boolean frameLost;
  private GameStatus game = new GameStatus();
  private FramePacket frame = new FramePacket();
  private KeysPacket keys = new KeysPacket();
  private AngleMonitor angle = new AngleMonitor();
  private TargetMonitor targets = new TargetMonitor();
  private TargetAnalyzer analyzer = new TargetAnalyzer();
  private TargetDetector detector = new TargetDetector();
  private BulletMonitor bullets = new BulletMonitor();
  private boolean fire;
  private boolean firePressed;
  private byte lastFrameByte;
  private int frameCounter;
  
  private TurnDirection lastTurn = TurnDirection.STILL;
  private int turnPrio;
  private boolean shipAlive;
  
  private AdjustBehaviour adjustBehaviour = new AdjustBehaviour();
  private SquareBehaviour squareBehaviour = new SquareBehaviour();
  private TestShotBehaviour testShotBehaviour = new TestShotBehaviour();
  private DefenseBehaviour defenseBehaviour = new DefenseBehaviour();
  private GreedyBehaviour greedyBehaviour = new GreedyBehaviour();
  
  private int level;
  private boolean levelSwitched = true;
  
  
  
  public AsteroidsPlayer(ServerConnection con)
  {
    this.con = con;
  }
  
  
  public boolean isFrameLost()
  {
    return frameLost;
  }


  public AngleMonitor getAngleMonitor()
  {
    return angle;
  }


  public GameStatus getGameStatus()
  {
    return game;
  }


  public TargetMonitor getTargetMonitor()
  {
    return targets;
  }


  public TargetDetector getTargetDetector()
  {
    return detector;
  }


  public BulletMonitor getBulletMonitor()
  {
    return bullets;
  }


  public boolean fire()
  {
    //System.out.println("try fire...");
    if (firePressed == false) {
      fire = true;
      //System.out.println("FIRE");
      return true;
    }
    else {
      return false;
    }
  }
  
  
  public void turn(TurnDirection dir, int prio)
  {
    if (prio < turnPrio) {
      return;
    }
    turnPrio = prio;
    
    switch (dir) {
      case LEFT :
        keys.left(true);
        keys.right(false);
        break;
      case RIGHT :
        keys.right(true);
        keys.left(false);
        break;
      case STILL :
    }
    
    //lastTurn = dir;
  }
  
  
  private void action()
  {
    targets.sync(game);
    bullets.sync(this);
    
    if (game.getShip() == null) {
      return;
    }
    
    if (adjustBehaviour.isAdjusted() && !angle.isConsistent(game, lastTurn)) {
      adjustBehaviour.startAdjust();
      testShotBehaviour.setState(TestShotBehaviour.TestShotState.TRIGGER);
    }
    
    if (!adjustBehaviour.isAdjusted()) {
      adjustBehaviour.action(this);
      return;
    }
    
    /*
    if (game.getAsteroids().size() <= 7 &&
        game.getSaucer() == null &&
        targets.getTargetsOnCollisionCount() == 0) {
      testShotBehaviour.action(this);
    }
    else {
      testShotBehaviour.setState(TestShotBehaviour.TestShotState.TRIGGER);
    */
    
    //squareBehaviour.action(this);
    
    defenseBehaviour.action(this);
      // vor greedy weil es TargetDetector nutzt, der ggf. hitDir loescht
    greedyBehaviour.action(this);
    //ufoBehaviour.action(this);
  }
  
  
  private TurnDirection getTurnDirection(byte keyByte)
  {
    if ((keyByte & KeysPacket.KEY_LEFT) > 0) {
      return TurnDirection.LEFT;
    }
    else if ((keyByte & KeysPacket.KEY_RIGHT) > 0) {
      return TurnDirection.RIGHT;
    }
    else {
      return TurnDirection.STILL;
    }
    //System.out.println("lastTurn: " + lastTurn);
  }
  
  
  private void setLastTurn(FramePacket frame)
  {
    byte keyByte = frame.getPing();
    lastTurn = getTurnDirection(keyByte);
    //System.out.println("lastTurn: " + lastTurn);
  }
  
  
  public TurnDirection getLastTurn()
  {
    return lastTurn;
  }
  
  
  public int getFrameNo()
  {
    return frameCounter;
  }
  
  
  public int getLevel()
  {
    return level;
  }


  private void receiveNextFrame() throws IOException
  {
    con.receive(frame);
    byte no = frame.getFrameNo();
    if (started) {
      frameLost = no != (byte) (lastFrameByte + 1);
    }
    else {
      started = true;
    }
    if (frameLost) {
      System.out.println("************* FRAME LOST / " + no);
    }
    lastFrameByte = no;
  }
  
  
  private static boolean isGoodShipPos(Position pos)
  {
    int dx = 400;
    int dy = 300;
    
    if (pos.getX() > X_MIN + dx && pos.getX() < X_MAX - dx) {
      return false;
    }
    if (pos.getY() > Y_MIN + dy && pos.getY() < Y_MAX - dy) {
      return false;
    }
    return true;
  }
  
  
  public void play() throws IOException
  {
    // GUI
    //AsteroidsDisplay display = AsteroidsDisplay.showDisplay();
    DebugPainter.get().setGameWorld(this);
    
    con.send(keys);
    receiveNextFrame();
    
    while (true) {
      receiveNextFrame();
      //display.update(frame.getPayload(), frameCounter++);
      //System.out.println("frame received");
      
      synchronized (this)
      {
        setLastTurn(frame);
        
        if (targets.getTargetCount() == 0 && !levelSwitched) {
          level++;
          System.out.println("===================================== Level: " + level);
          levelSwitched = true;
          System.gc();
        }
        if (targets.getTargetCount() > 0) {
          levelSwitched = false;
        }
        
        game.interpretScreen(frame, frameCounter);
        keys.clear();
        
        if (shipAlive && game.getShip() == null) {
          shipAlive = false;
          angle.ignoreLastMovement();
        }
        else if (!shipAlive && game.getShip() != null) {
          shipAlive = true;
        }
        
        // vor action(), dann ist angleCounter der prognostizierte naechste Winkel
        angle.registerMovement(lastTurn, game);
        
        analyzer.updateTargets(this);
        turnPrio = Integer.MIN_VALUE;
        action();
      }
      
      if (fire) {
        keys.fire(true);
        firePressed = true;
        fire = false;
      }
      else {
        firePressed = false;
      }
      
      /*
      if (game.getShip() != null && targets.getTargetCount() == 0 &&
          !isGoodShipPos(game.getShip())) {
        keys.hyperspace(true);
      }
      */
      
      // damit Tasten im zurckgegebenen Frame sichtbar
      keys.setPing(keys.getKeyByte());
      con.send(keys);
      
      //System.out.println("# " + (System.currentTimeMillis() - timestamp));
    }
  }
}
