package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;

//import org.apache.log4j.Logger;
public class TonyStrategieSimpleAiming extends Strategie {
	
//	public static final Logger logger = //logger.getLogger(TonyStrategieSimpleAiming.class);
	public static final int SAVETY_TIME = 15; //*3) = max
	public static final int NUMCHILDS = 4;
	public static final int MAXTREENODES = 700;
	public static final int SEARCH_DEPTH = 2;
	
	static int b = 0;
	private int lastFrameShot = -1;
	private List<MyAsteroid> childs;
	
	
	private List<MyAsteroid> targets;
	private FireSolution ce = null; //currently executed
	private TreeSet<FireSolution> firedShots = new TreeSet<FireSolution>();
	private int fireAgainShots = 0;
	private boolean fireAgainFireNow = false;
	private int fireAgainlastFrameFired;
	private int nodes;
	private int globalBest;
	
	
	public TonyStrategieSimpleAiming() {
	
	}
	
	
	
	
	public TastenTyp getEingabe(WorldObjects objects, StatusFlags status, int aktTick) 
	{
		
		if (	fireAgainShots>0 && 
				fireAgainFireNow )
		{
			if (aktTick-fireAgainlastFrameFired<2)
				return TastenTyp.NICHTS;
			
			//logger.debug("fireAgain(ct="+aktTick+"): last="+fireAgainlastFrameFired+"  shots="+fireAgainShots);
			fireAgainShots--;
			fireAgainlastFrameFired = aktTick;
			return TastenTyp.FEUER;
		}
		
		fireAgainFireNow = false;
	
		MyShip myShip = objects.getMyShip();
		MySaucer mySaucer = objects.getMySaucer();
		//do not change!
		List<MyAsteroid> myAsteroids2 = objects.getMyAsteroids();
		
		
		if (!status.ueberpruefe(StatusFlags.SHIP_EXISTS) || myShip==null)
		{
//			if (aktTick%1000==0)
//				System.out.println("****************dead*************");
			return TastenTyp.NICHTS;
		}

		if (!status.ueberpruefe(StatusFlags.ASTEROIDS_EXIST) && 
				!status.ueberpruefe(StatusFlags.SAUCER_EXISTS))
		{
//			if (aktTick%1000==0)
//				System.out.println("****************Level Complete*************");
			return TastenTyp.NICHTS;
		}
		
		
		
		
		if (checkForEmergency(myShip,objects.getMyShots(),myAsteroids2,aktTick))
			return TastenTyp.HYPERSPACE;
		
//		if(true) return TastenTyp.NICHTS;
		
		
		
		//check current execution valid & execute
		if (ce!=null)
		{
			if (!ce.canBeExecuted(myShip))
			{
				//logger.debug("FS could not be executed - deleting");
				ce=null;
				fireAgainShots=0;
			} else
			{
				return execute(myShip, aktTick);
			}
		}
		
		
		//copy in target list (saucer extra)
		targets = new LinkedList<MyAsteroid>();
		targets.addAll(myAsteroids2);
		//kill currently shot at targets
		MySaucer killedSaucer = killPendingTargets(mySaucer,targets,aktTick);
		if (killedSaucer!=null) mySaucer = killedSaucer;
		
		
		FireSolution crit = findAndShotCritical(myShip, targets, aktTick);
		if (crit!=null)
		{
			// add more shots to critical
			if (crit.getTarget() instanceof MyAsteroid) {
				MyAsteroid critast = (MyAsteroid) crit.getTarget();
				if (critast.getGroesseID()>1)
				{
					fireAgainShots=2; //gib 2 extraschsse auf das ziel ab
					//logger.debug("Set extra fire(ct="+aktTick+"): "+fireAgainShots);
				}
				
			}
			//logger.debug("got crit collision" + crit);
			ce = crit;
			return execute(myShip, aktTick);
		} else
			fireAgainShots=0;
	
		

		//shoot saucher
		if (ce==null && status.ueberpruefe(StatusFlags.SAUCER_EXISTS))
		{
			FireSolution tmp= myShip.getFireSolution(mySaucer);

			if (tmp!=null &&
					mySaucer.isAliveAndCertainAt(tmp.getHitTimeOuter())) //no other shot at target
			{
				ce = tmp;
				//logger.debug("new saucFS:"+ce);
				mySaucer.setDrawColor(Color.BLUE);

			}
		}
		
		if (ce==null)
		{
//			ce = getNextTargetFS(myShip, targets, aktTick);
			nodes = 0;
			globalBest = Integer.MAX_VALUE;
			ce = getNextTargetFSRekRoot(myShip, targets,SEARCH_DEPTH);
			//logger.debug("TREENODES:"+nodes+" (targets="+targets.size()+")");
		}
		
		return execute(myShip, aktTick);
		
		
		}
		
	
	private TastenTyp execute(MyShip myShip,int aktTick)
	{
		if (ce==null)
		{
			//logger.warn("nothing to execute!");
			return TastenTyp.NICHTS;
		}
		
		
		if (ce.canBeExecuted(myShip))
		{
			TastenTyp t = ce.execute(myShip);
			
			if (t.ordinal()==TastenTyp.FEUER.ordinal())
			{

				if (World.gameStatus.shots.size()<=3)
				{

					//logger.debug("firing(ct="+aktTick+", ft="+ce.getFireTime()+") at"+ce.getTarget());
					
					//fuege ausgefuehtere firesolution zu den aktiven hinzu
					firedShots.add(ce);

					ce = null;
					
					if (fireAgainShots > 0);
						fireAgainFireNow = true;
					fireAgainlastFrameFired = aktTick;
										
					
				}
				else
				{
					//logger.debug("ERRORcould not kill object!"+World.gameStatus.shots.size());
					return TastenTyp.NICHTS;
				}
			}
			return t;

		} else
		{
			//cannot be executed
			//logger.warn("FireSolution could not be executed! going to next: fireIn="
//					+(ce.getFireState().getCurrentTime()-myShip.getCurrentTime())
//					+" turn="+(myShip.getTurnTime(ce.getFireState().angleIndexByte))
//					+" data:"+ce+"  current"+myShip);
			
			ce = null;
			
			//da eh init im naechsten frame
			return TastenTyp.NICHTS;//execute(queue,s);
		}

	}
	
		
	
	public void draw(Graphics2D g)
	{
		if (ce!=null) 
			{
				ce.draw(g);
			}
		for(FireSolution fs:firedShots)
			fs.draw(g);
		
	}
	
	//targets werden verndert!
	private MySaucer killPendingTargets(MySaucer mySaucer, List<MyAsteroid> targets,int aktTick)
	{
		//check firedShots and add childs/kill asteroids
		MySaucer retSaucer = null;
		TreeSet<FireSolution> badFS = new TreeSet<FireSolution>();
		MyAsteroid child;
		boolean debug;
		int killCount = 0;
		int childCount = 0;
		
		for(FireSolution f:firedShots)
		{

			if (!f.willEndConsistentlyAfter(aktTick))
			{
				badFS.add(f);
				//logger.debug("found bad FS" +f );
				continue;
			}
			
			debug=false;
			
			//treat saucer extra
			if (f.getTarget() instanceof MySaucer) {
				debug=true;

				MySaucer s = (MySaucer) f.getTarget();
				s = new MySaucer(s);
				if (!s.killObject(f))
				{
					//logger.debug("Cannot kill target"+f.getTarget().getId()+": firesolution not valid,");
					continue;
				}
				//replace
				retSaucer = s;
				killCount++;
			}
			

			//treat asteroid
			if (f.getTarget() instanceof MyAsteroid) 
			{
				debug=true;
				MyAsteroid a = (MyAsteroid) f.getTarget();
				
				//kinder sind in liste, aber haben andere id, wenn jedesmal neu erzeugt werden! -> daher ign kinder
				//shot kann trotzedem noch unterwegs sein
				//TODO: glaub nicht ganz sauber
				if (a.isAliveAndCertainAt(aktTick) &&
						!targets.contains(a))
				{
					//frher getroffen, oder auf kind geschossen
					//logger.debug("Target not contained in targetlist, kannot kill! target:"+a+"    list:"+targets);
					badFS.add(f);
					continue;
				}

				
				//clone Asteroid
				a = new MyAsteroid(a);
			
				//kill Asteroid
				if (!a.killObject(f)) 
				{
					//logger.debug("Cannot kill target"+f.getTarget().getId()+": firesolution not valid,");
					continue;
					
				}
		
				//replace killed
				targets.remove(f.getTarget()); //because killed will be changed!
				targets.add(a);
				//logger.debug("killed ast "+a);
				killCount++;

				//add new children
				child = a.makeChild(f,false);
				if (child!=null)
				{
					childCount++;
					targets.add(child);
					//logger.debug("made child "+child);
					
					child = a.makeChild(f,false);
					if (child!=null)
					{
						targets.add(child);
						//logger.debug("made child "+child);
						childCount++;
					}
//					else 
						//logger.warn("aahh");
				}
				

			
			}
			
			//if (!debug)//logger.warn("fehler");
			
		}//for
		
		
		//saucer nicht mit drin
		//TODO: fehler bei, auf erzeugtes kind schieen, wrend die kinderzeugende kugel noch unterwegs ist -> dann werden fr alle kinder erzeugt!
		//ID'S der kinder gleich lassen! (auch nicht sauber)
		//
		//logger.debug("SHOT-FS="+firedShots.size()+", removing Bad SHOT-FS="+badFS.size()+", killedAst"+killCount+", addchilds="+childCount);
		
		firedShots.removeAll(badFS);
		
		return retSaucer;
		
		
		
	}
	
	private FireSolution findAndShotCritical(MyShip myShip,List<MyAsteroid> targets, int aktTick)
	{
			
		//find collisions
		TreeSet<Collision> crit = new TreeSet<Collision>();
		FireSolution tmp;
		Collision col;
		for(MyAsteroid a: targets)
		{

			a.setDrawColor(Color.black);
			a.setDrawStringWithObject(null);

			col = new  Collision(myShip,a);
			//valid solution?
			if (col.willOccurAfter(aktTick))
			{
				crit.add(col);
				a.setDrawColor(Color.magenta);
				a.setDrawStringWithObject("tHit="+col.getHitTimeOuter());

			}
		}
		
//		//logger.debug("found "+crit.size()+" collisions");
		
		//kill in order
		FireSolution f=null;
		MyShip lastShip = myShip;
		int savetyTime=Integer.MAX_VALUE;
		for(Collision c:crit)
		{
			f = lastShip.getFireSolution(c.getObject2());
			
			if (f!=null)
			{
				savetyTime = ((MyAsteroid)c.getObject2()).getGroesseID()*SAVETY_TIME;
//				savetyTime*=savetyTime;
			} else
			{
				savetyTime=-1;
			}
				
			
			if (f==null || !f.hasEndedConsistentlyUntil(c.getHitTimeOuter()-savetyTime))
			{
				//logger.debug("CRIT("+crit.size()+"):NOFS found!!! tHit="+c.getHitTimeOuter()+"(sv"+(c.getHitTimeOuter()-savetyTime)+") (shottime="+(f==null?"null":f.getFireTime())+") for:"+c.getObject2().getId()+"  ship:"+lastShip );
				f=null;
				break;
			}
			//logger.debug("CRIT("+crit.size()+"):FS found before hit: tHit="+c.getHitTimeOuter()+"(sv"+(c.getHitTimeOuter()-savetyTime)+") (shottime="+(f==null?"null":f.getFireTime())+") for:"+c.getObject2().getId()+"  ship:"+lastShip );			
			
			lastShip = f.getFireState();
			//lastShip.setFireTime(lastShip.getFireTime+savetyTime); //TODO:
		}
		
		//if critical
		if (f==null && crit.size()!=0)
		{
			//critical asteorid
			MyAsteroid critAst= (MyAsteroid)crit.first().getObject2();
			
			//create firesolution
			FireSolution ret = myShip.getFireSolution(critAst);

//			//create additional child
//			MyAsteroid auxChild = critAst.makeChild(ret, true);
//			if (auxChild!=null)	targets.add(auxChild);

			//logger.warn("collision Critical - closest: "+critAst.getId());
			

			return ret; 
			
		}
		return null;
		

	}
	
//	//nicht rekursiv
//	private FireSolution getNextTargetFS(MyShip myShip,List<MyAsteroid> targets, int aktTick)
//	{
//		nodes++;
//				
//		//find collisions
//		TreeSet<Collision> validCS = new TreeSet<Collision>();
//		FireSolution tmp;
//		MyShip tmpShip = myShip;
//		for(MyAsteroid a: targets)
//		{
//			tmp = tmpShip.getFireSolution(a);
//			
//			if (tmp!=null && tmp.canBeExecuted(tmpShip))
//			{
//				validCS.add(tmp.getCollision());
//				
//			}
//			else
//			{
//				if (tmp==null)
//				{
//					//logger.debug("NO FS for "+a.getId()+(a.getParent()==null?"":", parent="+a.getParent()));
//				} else
//				{
//					//logger.debug("NO FS for "+a.getId()+(a.getParent()==null?"":", parent="+a.getParent())+" cannot be executed!");
//				}
//			}
//
//		}
//		
//		if (validCS.size()!=0)
//			return myShip.getFireSolution(validCS.first().getObject1());
//		else
//			return null;
//
//
//	}
	
	private boolean checkForEmergency(MyShip myShip, List<MyShot> myShots, List<MyAsteroid> myAsteroids,int aktTick)
	{

		int rship = myShip.getRadius_outer();
		int rsq;
		Position sp = myShip.getPosition();
		Collision c;
		
		for(MyShot s:myShots)
		{
		
			rsq = rship+s.getRadius_outer();
			rsq*= rsq;
			
	//		//logger.debug("d_dist="+Position.distanceSquaredIgnoreTime(sp,s.getPosition())+" id="+s);
			if (Position.distanceSquaredIgnoreTime(sp,s.getPosition())<rsq)
			{
//				c = myShip.getCollisionWith(s);
//				
//				if (c!=null && c.willOccurAfter(aktTick))
					return true;
			}
		}
		
		for(MyAsteroid s:myAsteroids)
		{
			rsq = rship+s.getRadius_outer();
			rsq*= rsq;
			
		//	//logger.debug("distsqr="+Position.distanceSquaredIgnoreTime(sp,s.getPosition())+" id="+s);
			if (Position.distanceSquaredIgnoreTime(sp,s.getPosition())<rsq)
			{
//				c = myShip.getCollisionWith(s);
//				
//				if (c!=null && c.willOccurAfter(aktTick))
					return true;
			}
		}
//		//logger.debug("no jump at"+aktTick+"  myship="+myShip);
		return false;
		
		
	}
				
				
	
//	//returns best hittime
//	private int getNextTargetFSRek(MyShip myShip,List<MyAsteroid> targets, int depth)
//	{
//		if (depth==0) return myShip.getCurrentTime();
//		nodes++;
//
//		//find collisions
//		FireSolution tmp;
//		int bestHitTimeRek=Integer.MAX_VALUE;
//		int bestHitTime=Integer.MAX_VALUE;
//		
//		List<MyAsteroid> targetsMod;
//		MyAsteroid child;
//		MyAsteroid ast;
//		
//		for(MyAsteroid a: targets)
//		{
//			tmp = myShip.getFireSolution(a);
//			
//			if (tmp==null || !tmp.canBeExecuted(myShip))
//				continue;
//		
//			
//			
//			targetsMod = new LinkedList<MyAsteroid>();
//			
//			targetsMod.addAll(targets);
//			targetsMod.remove(a);
//
//			child = a.makeChild(tmp, false);
//			if (child!=null)
//				targetsMod.add(child);
//
//			child = a.makeChild(tmp, false);
//			if (child!=null)
//				targetsMod.add(child);
//			
//			ast = new MyAsteroid(a);
//			ast.killObject(tmp);
//			targetsMod.add(ast);
//			
//		
//			
//			
//			
//			bestHitTimeRek = 
//				getNextTargetFSRek(tmp.getFireState(), targetsMod, depth-1); //TODO targets - kill
//			
//			
//			
//			if (bestHitTimeRek<bestHitTime)
//			{
//				bestHitTime = bestHitTimeRek;
//			}
//	
//		}
//		
//		
//		
//		return bestHitTime;
//
//	}
	
	

	//first node, rek search
	private FireSolution getNextTargetFSRekRoot(MyShip myShip,List<MyAsteroid> targets, int depth)
	{
		nodes++;
	
		//find collisions
		FireSolution tmp;
		int bestHitTimeRek=Integer.MAX_VALUE;
		int bestHitTime=Integer.MAX_VALUE;
		
		List<MyAsteroid> targetsMod;
		MyAsteroid child;
		MyAsteroid ast;
		FireSolution bestFS=null;
		
		for(MyAsteroid a: targets)
		{
			tmp = myShip.getFireSolution(a);
			
			if (tmp==null || !tmp.canBeExecuted(myShip))
				continue;
			
			
			
			
			targetsMod = new LinkedList<MyAsteroid>();
			
			targetsMod.addAll(targets);
			targetsMod.remove(a);

			child = a.makeChild(tmp, false);
			if (child!=null)
				targetsMod.add(child);

			child = a.makeChild(tmp, false);
			if (child!=null)
				targetsMod.add(child);
			
			ast = new MyAsteroid(a);
			ast.killObject(tmp);
			targetsMod.add(ast);
			
			
			bestHitTimeRek = 
				getNextTargetFSRekSort(tmp.getFireState(), targetsMod, depth-1);
			
			
			if (bestHitTimeRek<=bestHitTime)
			{
				bestHitTime = bestHitTimeRek;
				bestFS = tmp;
			}
	
		}
		
		return bestFS;

	}
	
	//returns best hittime
	private int getNextTargetFSRekSort(MyShip myShip,List<MyAsteroid> targets, int depth)
	{
		if (depth==0) return myShip.getCurrentTime();
		nodes++;
		if (nodes>MAXTREENODES) return myShip.getCurrentTime();
				
		//find collisions
		FireSolution tmp;
		FireSolution[] bestFS = new FireSolution[NUMCHILDS];
		
		int bestHitTimeRek=Integer.MAX_VALUE;
		int bestHitTime=Integer.MAX_VALUE;
		
		List<MyAsteroid> targetsMod;
		MyAsteroid child;
		MyAsteroid ast;
		
		for(MyAsteroid a: targets)
		{
			tmp = myShip.getFireSolution(a);
			
			if (tmp==null || !tmp.canBeExecuted(myShip))
				continue;
			
			for (int i=0;i<NUMCHILDS;i++)
				if (bestFS[i]==null || 
					tmp.getHitTimeOuter()<bestFS[i].getHitTimeOuter())
				{
					bestFS[i] = tmp;
					break;
				}
	
		}
		
		for (int i=0;i<NUMCHILDS;i++)
		{
			tmp = bestFS[i];
			if (tmp==null) continue;
			
			MyAsteroid a = (MyAsteroid) tmp.getTarget();
			
			targetsMod = new LinkedList<MyAsteroid>();
			
			targetsMod.addAll(targets);
			targetsMod.remove(a);
	
			child = a.makeChild(tmp, false);
			if (child!=null)
				targetsMod.add(child);
	
			child = a.makeChild(tmp, false);
			if (child!=null)
				targetsMod.add(child);
			
			ast = new MyAsteroid(a);
			ast.killObject(tmp);
			targetsMod.add(ast);
			
			
			bestHitTimeRek = 
				getNextTargetFSRekSort(tmp.getFireState(), targetsMod, depth-1); //TODO targets - kill
			
			
			if (bestHitTimeRek<bestHitTime)
			{
				bestHitTime = bestHitTimeRek;
			}
		}

		
		
		
		return bestHitTime;

	}
}
