package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
public class TonyStrategieSimple extends Strategie {
	
	public static final Logger logger = Logger.getLogger(TonyStrategieSimple.class);
	
	private MyShip myShip;
	private MySaucer mySaucer;
	private List<MyAsteroid> myAsteroids;
	static int b = 0;
	private int turnRight=0;
	private List<MyAsteroid> geschossenAufAsteroiden;
	
	
	
	
	public TonyStrategieSimple() {
		myShip = null;
		mySaucer = null;
		myAsteroids = null;
		geschossenAufAsteroiden = new ArrayList<MyAsteroid>();
	}
	
	
	
	
	public TastenTyp getEingabe(WorldObjects objects, StatusFlags status, int aktTick) {
		

		
		
		this.myShip = objects.getMyShip();
		this.mySaucer = objects.getMySaucer();
		this.myAsteroids = objects.getMyAsteroids();
		float f; //temp var
		
		
		if (myShip==null)
		{
			if (aktTick%100==0)
				logger.debug("****************dead*************");
			return TastenTyp.NICHTS;
		}

		if (myAsteroids.isEmpty()&&mySaucer==null)
		{
			if (myShip.getCurrentTime()%2000==0)
				logger.debug("****************Level Complete*************");
			return TastenTyp.NICHTS;
		}
		

		
//		if (myShip.getCurrentTime()%2==0) 
//			return TastenTyp.NICHTS;
		


		//find critical asteroids
		int numCrit =0;
		float critDist =Float.MAX_VALUE;
		float deathDist = 83 //rotation time (3critical
						  +2*10  //shot time for in between shots
						  +MyShot.BULLETLIFETIME; //max bullet range
		deathDist*=3; //worst case 3 critical asteroids
		MyAsteroid critical = null;
		Collision col=null;
		Collision critCol=null;
		
		for(MyAsteroid a: myAsteroids)
		{
			col = myShip.getCollisionWith(a);
			
			//valid solution?
			if (col==null || !col.willOccurAfter(aktTick)) continue;
			
			f = col.getHitTimeOuter()-myShip.getCurrentTime();
			
			//logger.debug("time="+f);
			
			if (f>0 && f<deathDist)
			{
				numCrit++;
				col.getObject2().setDrawColor(Color.MAGENTA);
				col.getObject2().setDrawStringWithObject(""+f);
				if (f<critDist)
				{
					critDist = f;
					critical = a;
					critCol = col;
				
				}
				
			} else
			{
				col.getObject2().setDrawColor(Color.black);
				col.getObject2().setDrawStringWithObject("");
			}
		}
		if (numCrit>0) 
		{
			logger.debug("critical("+numCrit+")"+critCol);
		}
		
		
		
		
		
		
		
	
			
			

			
			
		


		
		//test if bullet would hit an asteroid
		MyShot bullet = myShip.shootNow();
		
		for(MyAsteroid a: myAsteroids)
		{
			col = a.getCollisionWith(bullet);
			
			//valid solution?
			if (col==null || 
				!col.willOccurAfter(aktTick) ||
				!col.willOccurAfter((int)Math.round(col.getHitTimeOuter()-5)))
			 		continue;
		
			f = col.getHitTimeOuter()-a.getCurrentTime();
	
			
			if (f>0 && f<MyShot.BULLETLIFETIME)
			{
				
				if (a==critical) 
				{
					if (objects.getMyShots().size()>=MyShip.MAXBULLETS)
						return TastenTyp.NICHTS;
					
					turnRight=3;
//					logger.debug("Shot at critical("+numCrit+"):"+col);
					a.killObject(new FireSolution(myShip,a));
					
					return TastenTyp.FEUER;
				}
//				if (a.getProbBeeingAlive(aktTick)<=Collision.INNERHITPROBABILITY) //TODO
//				{
//					if (objects.getMyShots().size()>=MyShip.MAXBULLETS)
//						return TastenTyp.NICHTS;
//
//					//logger.debug("Shot at Asteroid:"+col);
//
//					a.killObject(new FireSolution(myShip,a));
//						
//					return TastenTyp.FEUER;
//				
//					
//					
//		
//				}
				
			} 
		}
		
		
		
		////test if bullet would hit the saucer
		if (mySaucer!=null)
		{
			col = mySaucer.getCollisionWith(bullet);
			
			//valid solution?
			if (col!=null && col.willOccurAfter(aktTick)) 
			{
			
				f = col.getHitTimeOuter()-mySaucer.getCurrentTime();
		
				logger.debug(col);
				//logger.debug(mySaucer);
				
				if (f>0 && f<MyShot.BULLETLIFETIME)
				{

					if (objects.getMyShots().size()>=MyShip.MAXBULLETS)
						return TastenTyp.NICHTS;

					logger.debug("UFO("+f+"):"+mySaucer+" bullet:"+bullet);

					if (numCrit==0)turnRight=3;
					
					mySaucer.killObject(new FireSolution(myShip,mySaucer));					

					return TastenTyp.FEUER;
				}
			}
		}
		
		
		
		//if nothing can be hit then rotate
		if (turnRight>0)
		{
			//logger.debug("turning right");
			turnRight--;
			return TastenTyp.RECHTS;
		}
		
		
		return TastenTyp.LINKS;
		}			
		
	
	public void draw(Graphics2D g)
	{
		
	}
				
				

		
	
}
