package hek.de.hinni.hek.asteroids;

import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.omg.CORBA.PRIVATE_MEMBER;

/*
 * macht statistische Auswertungen
 */
public class StrategieHinniStatistik extends Strategie {
	private MyObject naechstesZiel;
	private FireSolution naechsteFiresolution;
	private int asteroidenAnz;
	private int schuesseAbzugeben;
	private boolean pause;
	private boolean gueltig;
	private final int GROESSE = 0;
	private final int SCHUESSE = 1;
	private int[][] treffer;
	private int[][] anzSchuesse;
	private int trefferGross4Schuss; //erwartungswert für Für Treffer mit 4 Schüssen auf einen großen Asteroiden
	private int anzGross4Schuss;
	private int trefferMittel3Schuss;
	private int anzMittel3Schuss; 
	
	public StrategieHinniStatistik() {
		naechstesZiel = null;
		naechsteFiresolution = null;
		schuesseAbzugeben = 0;
		pause = false;
		trefferGross4Schuss = 0;
		trefferMittel3Schuss = 0;
		treffer = new int[3][4];
		anzSchuesse = new int[3][4];
	}
	/*
	 * gibt zurück wieviele Schuesse man noch abgeben kann
	 */
	public int berechneFreieSchuesse(List<MyShot> shots) {
		int erg = 4;
		for (MyShot s: shots) {
			if (s.isVisible())
				--erg;
		}
		return erg;
	}
	
	public static final Logger logger = Logger.getLogger(StrategieHinniStatistik.class);
	private int zaehleAsteroiden(List<MyAsteroid> asteroiden) {
		int anz = 0;
		for (MyAsteroid a: asteroiden) {
			anz += Math.pow(2,a.getGroesseID()) - 1;
		}
		//logger.info("Jetzt gibt es Asteroiden " + anz);
		return anz;
	}
	public TastenTyp getEingabe(WorldObjects objects, StatusFlags status, int aktTick) {
		if (aktTick == 18000) {
			for (int i = 0; i < 3; i++)
				for (int j = 0; j < 4; j++) {
					if (anzSchuesse[i][j] != 0)
					logger.fatal("Groesse "+(i+1) + "Jeweils Schuesse " + (j+1) + "Insg Schuesse " + anzSchuesse[i][j] + "Insg Treffer" + treffer[i][j] + "Quote " + (float)treffer[i][j]/anzSchuesse[i][j]);
				}
			return null;
		}
		//wenn vorheriges Ziel tot, werte Ergebnis aus
		MyShip ship = objects.getMyShip();
		if (!status.ueberpruefe(StatusFlags.SHIP_EXISTS))
			return TastenTyp.NICHTS;
		if (status.ueberpruefe(StatusFlags.SAUCER_EXISTS)) {
			gueltig = false;
		}
		if (naechstesZiel != null) {
			if (berechneFreieSchuesse(objects.getMyShots()) == 4) { 
			if (!objects.getMyAsteroids().contains(naechstesZiel)) {//ziel wurde abgeschossen und alle 4 schüsse sind angekommen
				MyAsteroid astZiel = (MyAsteroid)naechstesZiel;
				int schuesse = (int)Math.pow(2,astZiel.getGroesseID())-1;
				if (schuesse > 4)
					schuesse = 4;
				int diff = asteroidenAnz - zaehleAsteroiden(objects.getMyAsteroids());
				float quote = ((float)(diff)/schuesse);
				
				treffer[astZiel.getGroesseID() - 1][schuesse-1] += diff;
				anzSchuesse[astZiel.getGroesseID() - 1][schuesse-1] += schuesse;

				if (gueltig)
					logger.info(diff+ "Treffer von" + schuesse + "trefferquote" + quote);
				naechstesZiel = null;
				
				
			}
			}
			
		}
		else {
			//wenn, kein Ziel, suche ein Ziel, speicher es
			LinkedList<FireSolution> firesolutions = new LinkedList<FireSolution>();
			for (MyAsteroid a: objects.getMyAsteroids()) {
				FireSolution fs = objects.getMyShip().getFireSolution(a, true, 0f,objects.getMyShip().getCurrentTime());
				if (fs != null)
					firesolutions.add(fs);
			}
			int min = aktTick + 100;
			FireSolution myFS = null;
			for (FireSolution fs: firesolutions) {
				if (fs.canBeExecuted(ship) && fs.getTarget().bewegungIstGenau()) {
					if (fs.getHitTimeInner() < min) {
						min = fs.getHitTimeInner();
						myFS = fs;
					}			
				}
			}
			if (myFS != null) {
				naechstesZiel = myFS.getTarget();
				naechsteFiresolution = myFS;
				//ueberpruefe, dass keine anderen Ziele getroffen werden
				for (MyAsteroid a: objects.getMyAsteroids()) {
					if (a != myFS.getTarget()) {
						Collision c = new Collision(ship.shootNow(), a);
						if (c.willOccurAfter(aktTick)) {
							naechstesZiel = null;
							return TastenTyp.NICHTS;
						}
					}
				}
				asteroidenAnz = zaehleAsteroiden(objects.getMyAsteroids());
				gueltig = true;
			}
			
		}
		if (naechstesZiel == null)
			return TastenTyp.NICHTS;
		if (schuesseAbzugeben > 0) {
			if (pause) {
				pause = false;
				return TastenTyp.NICHTS;
			}
			else {
				pause = true;
				schuesseAbzugeben--;
				return TastenTyp.FEUER;
			}
		}
		FireSolution fs = naechsteFiresolution;
		if (fs.canBeExecuted(objects.getMyShip())) {
			TastenTyp t= fs.execute(objects.getMyShip());
			if (t != TastenTyp.FEUER)
				return t;
			else {
				MyObject ziel = naechstesZiel;
				if (ziel.getType() == Position.TYPE.ASTEROID) {
					MyAsteroid astZiel = (MyAsteroid)ziel;
					schuesseAbzugeben = (int)Math.pow(2,astZiel.getGroesseID())-1;
					if (schuesseAbzugeben > 4)
						schuesseAbzugeben = 4;
				}
				pause = true;
				--schuesseAbzugeben;
				return TastenTyp.FEUER;
			}
					
		}
		
			

		
		
		

		//berechne Parameter für das Ziel	
		
		if (fs.getFireTime() + 100 <   aktTick)
			naechstesZiel = null;
		return TastenTyp.NICHTS;
	}
	public void draw( Graphics2D g ) {
		
	}

}
