package hek.de.hinni.hek.asteroids;

import java.io.IOException;

/**
 * The <code>Player</code> class implements main player loop.
 * <p>
 * It uses blocking UDP sockets.
 */
public class Player {
	protected ServerConnection serverConnection;

	/**
	 * Initializes a Player with given server connection.
	 *
	 * @param serverConnection
	 *        the server connection
	 */
	public Player(ServerConnection serverConnection) {
		this.serverConnection = serverConnection;
	}

	/**
	 * Implements the main game loop.
	 *
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public void run() throws IOException, InterruptedException {
		FramePacket framePacket = new FramePacket();
		KeysPacket keysPacket = new KeysPacket();
		GameStatus gameStatus = new GameStatus();
		byte prevFrameNo = 0;
		int ticks = 0;

		while (true) {
			++ticks; // time
			// in order to determine latency each sent packet increments the ping value
			keysPacket.setPing((byte) (keysPacket.getPing() + 1));
			serverConnection.send(keysPacket);
			serverConnection.receive(framePacket);

			if (framePacket.getFrameNo() != ++prevFrameNo || framePacket.getPing() != keysPacket.getPing()) {
				System.out.println(String.format("Latency %d. %d frames lost.",
						keysPacket.getPing() - framePacket.getPing(),
						framePacket.getFrameNo() - prevFrameNo));
				prevFrameNo = framePacket.getFrameNo();
			}

			gameStatus.interpretScreen(framePacket, ticks);
			// dump game status
			System.out.println(gameStatus);
			decide(gameStatus, keysPacket);
		}
	}
	
	/**
	 * Implements the player character.
	 *
	 * @param gameStatus
	 * 			the current game status. The player should react to this
	 * @param keysPacket
	 * 			the players reaction in form of pressed keys
	 */
	public void decide(GameStatus gameStatus, KeysPacket keysPacket) {
		/*Ship ship = gameStatus.getShip();
		Saucer saucer = gameStatus.getSaucer();
		Vector v = new Vector(ship.getOrientation());
		System.out.println("Orientation muesste ergeben: ");
		System.out.println(v.getWinkel());
		System.out.println("Winkelbyte ergibt: ");
		System.out.println(ship.getWinkelByte().byte2winkel());
		// reset all keys
		keysPacket.clear();
		int minDistance = 0x7fffffff;
		Position minDifference = new Position();
		if (ship != null) {
			// search for nearest asteroid
			for (Asteroid asteroid: gameStatus.getAsteroids()) {
				Position difference = Position.substract(asteroid, ship);
				difference.normalize(-512, 511, -384, 383);
				// the squared distance
				int distance = Position.dotProduct(difference, difference);
				// adjust the squared distance for the radius of the asteroid
				distance -= asteroid.getSize().getRadius() * asteroid.getSize().getRadius();
				if (distance < minDistance) {
					minDistance = distance;
					minDifference = difference;
				}
			}
			if (saucer != null) {
				Position difference = Position.substract(saucer, ship);
				difference.normalize(-512, 511, -384, 383);
				int distance = Position.dotProduct(difference, difference);
				// adjust the squared distance for the radius of the flying saucer
				distance -= saucer.getSize().getDistanceCorrection();
				if (distance < minDistance) {
					minDistance = distance;
					minDifference = difference;
				}
			}
*/
			// turn the ship towards the nearest object
			/*if (Position.crossProduct2D(ship.getOrientation(), minDifference) > 0)
				ship.drehLinks(keysPacket);
			else
				ship.drehRechts(keysPacket);

			if (minDistance < 27 * 27) // evade collision with jump to hyperspace
				ship.hyperSpace(keysPacket);

			if (minDistance > 400 * 400) // accelerate when no object is near
				ship.beschleunige(keysPacket);

			if (gameStatus.getTicks() % 2 == 0) // fire as fast as possible
				ship.schiess(keysPacket);*/
		}
	}

//}
