package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;

//import org.apache.log4j.Logger;

//contains all data necessary to destroy an asteroid
//should not be changed since flat copys are used everywhere
public class FireSolution implements Comparable<FireSolution>{
	
//	public static final Logger logger = Logger.getLogger(FireSolution.class);
	public static final Color COLOR = Color.red;
	//ship state at fire time
	private MyShip fireState;

	//obj 1 = target
	//obj 2 = bullet
	private Collision c; 
	
	
	
	//debuging list
	public List<Position> optTargets; 

	
	
	public void setDrawString(String drawString) {
		c.setDrawString(drawString);
	}
	public void setDrawColor(Color drawColor) {
		c.setDrawColor(drawColor);
	}
	public Color getDrawColor() {
		return c.getDrawColor();
	}
	public String getDrawString()	{
		return c.getDrawString();
	}	
	public final MyObject getTarget() {
		return c.getObject1();
		
	}
	
	


	
	public boolean isConsistent()
	{
		boolean b=
			c!=null &&  
			fireState!=null &&
			fireState.isAliveAndCertainAt(getFireTime()) &&
			c.willOccurAfter(fireState.getCurrentTime());

//		if(!b)
//		logger.debug("Not Consistent:"+
//				(c!=null) +
//				(fireState!=null) +
//				(fireState.isAliveAndCertainAt(getFireTime()))+
//				(c.willOccurAfter(fireState.getCurrentTime())));
		
		return 	b; 
	}
	
	public boolean hasEndedConsistentlyUntil(int time)
	{
		return isConsistent() && c.willOccurBefore(time); 
	}
	
	public boolean willEndConsistentlyAfter(int time)
	{
		return isConsistent() && c.willOccurAfter(time); 
	}
	
	public MyShip getFireState() {
		return fireState;
	}
	

	//the tick the fire key is pressed
	public int getFireTime() {
		return fireState.getCurrentTime();
	}


	public MyShot getBullet() {
			return (MyShot)c.getObject2();
	}
	

	public FireSolution(MyShip shipState, MyObject target)
	{
		c = new Collision(target,shipState.shootNow());
		c.setDrawColor(COLOR);
		fireState = new MyShip(shipState);
	}

	//copy constructor (deep)
	public FireSolution(FireSolution f)
	{
		if (f==null) return;
		if (f.getTarget() instanceof MyAsteroid) {
			MyAsteroid a = (MyAsteroid) f.getTarget();
			c = new Collision(new MyAsteroid(a),f.fireState.shootNow());
		}
		if (f.getTarget() instanceof MySaucer) {
			MySaucer a = (MySaucer) f.getTarget();
			c = new Collision(new MySaucer(a),f.fireState.shootNow());
		}
		fireState = new MyShip(f.fireState);
	}

	/**
	 * Tests, if there is enough time to turn and fire the ship,
	 * given the present ship.
	 * 
	 * @param currentShip	current ship state
	 * @return				if there is enough time for turning and firing
	 */
	public boolean canBeExecuted(MyShip currentShip)
	{
		return isConsistent() && (execute(currentShip)!=null);
	}
	
	
	public String toString()
	{
		return ""+fireState+"      "+c;
	}
	
	
	//dreht das schiff und schiet wenn winkel stimmt
	public TastenTyp execute(MyShip currentShip)
	{

		int tc = currentShip.getCurrentTime();
		int td = fireState.getCurrentTime();

		//feuerzeit verpasst?
		if (tc>td)
		{
//			logger.debug("Missed correct firetime! (tc="+tc+" td="+td+" angC="+currentShip.angleIndexByte+" angD="+fireState.angleIndexByte);
			return null;
		}

		//prft ob ers zeitlich berhaupt noch schaffen kann
		if (td-tc<currentShip.getTurnTime(fireState.angleIndexByte))
		{
//			logger.debug("Not enough time to reach FireState! (tc="+tc+" td="+td+" angC="+currentShip.angleIndexByte+" angD="+fireState.angleIndexByte);
			return null;
		}
		
		
		//drehe zum winkel
		TastenTyp t=currentShip.turnTowards(fireState);
		
		//firing at tc==td 
		if (t.compareTo(TastenTyp.NICHTS)==0 && tc==td)
		{
			return TastenTyp.FEUER;
		}
		
		//wait
		
		//logger.debug("waiting "+(fireState.getCurrentTime()-currentShip.getCurrentTime())+"   "+this);
		return t;
		
	}
	
	
	
	public void draw(Graphics2D g)
	{
		if (!isConsistent())
		{
//			logger.debug("cannot draw FireSoloution - not consistent!"+this);
			isConsistent();
			return;
		}
		c.draw(g);
		

//		if (MyShip.logger.isDebugEnabled())
//		{
//		
//		MyShip tmp = new MyShip(fireState);
//		tmp.execute(TastenTyp.LINKS, StatusFlags.SHIP_EXISTS);
//		
//		MyShot sl = tmp.shootNow();
//		sl.setDrawColor(Color.YELLOW);
//		
//		sl.draw(g);
//
//		tmp.execute(TastenTyp.RECHTS, StatusFlags.SHIP_EXISTS);
//		tmp.execute(TastenTyp.RECHTS, StatusFlags.SHIP_EXISTS);
//		
//		MyShot sr = tmp.shootNow();
//		sr.setDrawColor(Color.YELLOW);
//		
//		sr.draw(g);
//		
//		
//		if (optTargets!=null)
//			for(Position p:optTargets)
//			{
//				g.setColor(p.getDrawColor());
//				g.drawOval(p.getXforDrawing()-p.getSize_inner()/8, p.getYforDrawing()-p.getSize_inner()/8,
//						2*p.getSize_inner()/8, 2*p.getSize_inner()/8);
//				
//			}
//		}

	}
	
	public float getHitProbability()
	{
		return c.getHitProbability();
	}
	
	public int getHitTimeInner()
	{
		return c.getHitTimeInner();
	}
	
	public int getHitTimeOuter()
	{
		return c.getHitTimeOuter();
	}
	
	
	
	
	/**
	 * Compares with respect to firetime
	 * @param f
	 * @return	-1 if firetime<f.firetime 
	 * 			0 if firetime==f.firetime
	 * 			1 if firetime>f.firetime || f==null
	 */
	public int compareTo(FireSolution f)
	{
		if (f==null) return 1;
		if (getFireTime()==f.getFireTime()) return 0;
		return getFireTime()<f.getFireTime()?-1:1;
	}
	
	@Override
	public boolean equals(Object o)
	{
		if (this == o) return true;
			
		if (o == null) return false;
			
		if (o instanceof FireSolution) 
		{
			return compareTo((FireSolution) o)==0;
		} 
		else
		{
			return false;
		}

	}
	
	public Collision getCollision()
	{
		return c;
	}
		
}
