#ifndef ASTEROID_H
#define ASTEROID_H

#include <set>
#include "MovingObject.h"
#include "../FrameStatus/ObjectLink.h"


/// \brief Represents an asteroid.

class Asteroid : public MovingObject, public ObjectLink<Asteroid>::Linkable
{
public:
    int type; // 1 ... 4, aussere Form
    int sf;   // scale factor: 0 = gross, 15 = mittel, 14 = klein

    Asteroid* prev;
    Asteroid* next;

    virtual std::string className() {return "Asteroid";}

    virtual ~Asteroid()
    {
        if (next) next->prev = 0;
    }


    Asteroid() {}


    Asteroid(FrameStatus* frame, int x, int y, int type, int sf)
    : MovingObject(frame,x,y), prev(0), next(0), type(type), sf(sf)
    {
        this->type = type;
        this->sf = sf;
    }

    Asteroid(int x, int y, int type, int sf)
    : MovingObject(0,x,y), prev(0), next(0),sf (sf), type(type)
    {}

    virtual double diameter() 
    {
        if (sf== 0) return 32.;
        if (sf==15) return 16.;
        return 8.;
    }

};

#endif
