#include "smartAsteroid.h"
#include "definitions.h"

smartAsteroid::smartAsteroid(void)
:act_pos(object_vector(-1.0,-1.0))
,fst_pos(object_vector(-1.0,-1.0))
,fst_tick(0)
,size(c_bigSized)
,has_position(false)
,is_free(true)
,pilot_lock(false)
,type(0)
{
	erase();
}

smartAsteroid::~smartAsteroid(void)
{
}

smartAsteroid* p = NULL;

void smartAsteroid::update(int new_x, int new_y, scale_factor_t sf, asteroid_type new_type)
{
   //ASSERT(new_type == 5 || type == new_type);

   if(!(new_type == 5 || type == new_type))
   {
      //hack to correct minor flaws in object assignment
      this->initialize(new_x, new_y, sf, new_type);
      return;
   }
   else
   {
      //DO NOTHING HERE
   }
	this->type = new_type;

	//erst die Richtung bestimmen...
   int x = new_x - act_pos.x;
   int y = new_y - act_pos.y;

   while (x < -512) x += 1024; // dx normalisieren auf -512 ... 511
   while (x > 511) x -= 1024;

   while (y < -384) y += 768;  // dy normalisieren auf -384 ... 383
	while (y > 383) y -= 768;

   speed.x += x;
   speed.y += y;
   last_tick = GetTickCount();

   //neue Position benehmen
	act_pos.x = new_x;
	act_pos.y = new_y;
	//neue Position benehmen
}

void smartAsteroid::initialize (int x, int y, scale_factor_t sf, asteroid_type tp)
{
	fst_pos.x = (double)x;
	fst_pos.y = (double)y;

	act_pos.x = (double)x;
	act_pos.y = (double)y;

   speed.x = 0.0;
   speed.y = 0.0;

	size = sf;

   type = tp;

	has_position = true;
	is_free = false;
   initiated = true;

   update_able = true;

	pilot_lock = false;

	//Umgebendes Rechteck  neu ermitteln
	recalc_rect ();

	//Zeit festhalten
	fst_tick = GetTickCount();
}

void smartAsteroid::recalc_rect (void)
{
	//Radius berechen

	// aus Player.cpp: 
	// (Zeile 69...bis 77)
	// Radius gro   = 40
	// Radius mittel = 20
	// Radius klein  =  8
	int radius = 0;

	switch (size)
	{
	case c_smallSized:
		radius = 8;
		break;
	case c_mediumSized:
		radius = 20;
		break;
	case c_bigSized:
		radius = 40;
		break;
	default:
		//In diesen Zweig kann ich eigentlich nicht reinkommen,
		//Wenn aber doch, dann gehe ich fr die Kollisionserkennung
		//im Zweifel von einem groen Asteroiden aus...
		radius = 40;
		break;
	}

	rect.left	= (LONG)(act_pos.x - radius);
	rect.right	= (LONG)(act_pos.x + radius);
	rect.bottom = (LONG)(act_pos.y - radius);
	rect.top	= (LONG)(act_pos.y + radius);

}

smartAsteroid::smartAsteroid(int in_x1, int in_y1, int in_x2, int in_y2, scale_factor_t in_size, asteroid_type tp)
{
	act_pos.x = (double)in_x2;
	act_pos.y = (double)in_y2;

   type = tp;

	this->size = in_size;
}


void smartAsteroid::dump()
{
	//printf("%p\tposition (%f, %f)\tdirection (%f, %f)\n", this,act_pos.x, act_pos.y,direction.x, direction.y);
}

void smartAsteroid::erase (void)
{
	is_free		= true;
	pilot_lock	= false;
	has_position= false;
   initiated = false;

	fst_tick	= 0;
	last_tick	= 0;
	
	type		= 4711;

	fst_pos		= object_vector(-33333.0,-333.0);
	act_pos		= object_vector(-333.0,-333.0);
	speed		= object_vector(-333.0,-333.0);
	
	rect.bottom = 0;
	rect.top	= 0;
	rect.left	= 0;
	rect.right  = 0;

	size		= c_bigSized;
	lock_time	= 0;
}

void smartAsteroid::get_speed(object_vector& obj_speed)
{
   double divisor = (last_tick - fst_tick);
   if(0.0 == divisor)
      divisor = 1.0;

   obj_speed = speed / divisor;
}

bool smartAsteroid::is_locked()
{
	if (pilot_lock)
	{
		if (GetTickCount()-lock_time > MAX_LOCK_TIME)
		{
			pilot_lock = false;
		}
		else
		{
			//do nothing here
		}
	}
	else
	{
		//do nothing here
	}

	return pilot_lock;
}

void smartAsteroid::set_lock()
{
	if (pilot_lock eq false)
	{
		pilot_lock = true;
		lock_time = GetTickCount();
	}
}
