#ifndef SCHEDULER_H_
#define SCHEDULER_H_

#include "gameobject.h"
#include "objectmanager.h"
#include "game.h"
#include <vector>

using std::vector;


class Task
{
public:
	int type;
	int frameno;
	GameObject* obj;
	
	Task(int fno, int tpe, GameObject* ob);
	
	
};


class TaskList
{
public:
	int frameno;
	ObjectManager* m_asteroids;
	ObjectManager* m_shots;
	KeysPacket* keys;
	vector<Task> tasklist;
	
	void connect(GameStatus* gstate, ObjectManager* m_ast, ObjectManager* m_sht, KeysPacket* kys);
	int now(); 
	bool execute();
	bool plan(int type);
	bool plan(int type, GameObject* obj);
	bool plan(int fno, int type);
	bool plan(int fno, int type, GameObject* obj);	
};





#endif /*SCHEDULER_H_*/
