
#include "gamestatus.h"

GameStatus::GameStatus (void)
:  state(unknown),
	events(nothing),
	nasteroids(0),
	nbigasteroid(0),
	nmidasteroid(0),
	nsmallasteroid(0),
	nshots(0),
	nexplosions(0),
	t(0),
	frameno(0),
	score(0),
	lifes(0),
	level(0)
{
	ship.present = false;
	saucer.size = 0;
}

void GameStatus::clear(void)
{
	state = unknown;
	events = nothing;
	ship.present = false;
	saucer.size = 0;
	nasteroids = 0;
	nbigasteroid = 0;
	nmidasteroid = 0;
	nsmallasteroid = 0;
	nshots = 0;
	nexplosions = 0;
	lifes = 0;
}

// Kometen-Anzeige==============
void GameStatus::Kometenanzeige(ObjectManager* objm, ObjectManager* shotm, Saucer* saucer, Ship* ship)
{

	Ship *shp = ship;		
	int cnt = objm->count();
	int scnt = shotm->count();
	printf("%d asteroids ========= frameno: %d =================\n", cnt, frameno);
	for (int i = 0; i < cnt; i++)
	{
		GameObject *ast = (*objm)[i];
		printf("Typ: %d, x(%.0f, %.0f), v(%.2f, %.2f), tag: %d, age: %d, ft: %.0f\n", ast->objecttype, ast->pos.x, ast->pos.y, ast->vel.x, ast->vel.y, ast->tag, ast->age, ast->att_flighttime);
		//printf("Typ: %d, x(%.0f, %.0f), v(%.1f, %.1f), rad: %d, pri: %d, tag: %d, age: %d, ft: %.0f\n", ast->objecttype, ast->pos.x, ast->pos.y, ast->vel.x, ast->vel.y, ast->radius, ast->prio, ast->tag, ast->age, ast->att_flighttime);
	}
	printf("%d shots------------------------------------------------------\n", scnt);	
	for (int i = 0; i < scnt; i++)
	{
		GameObject *sht = (*shotm)[i];
		printf("Typ: %d, x(%.0f, %.0f), v(%.2f, %.2f), tag: %d, age: %d\n", sht->objecttype, sht->pos.x, sht->pos.y, sht->vel.x, sht->vel.y, sht->tag, sht->age);
	}
	if (saucer->IsPresent())
	{
		printf("------------------------------------------------------\n");	
		GameObject *sar = saucer;
		printf("Typ: %d, x(%.0f, %.0f), v(%.2f, %.2f), rad: %d, prio: %d\n", sar->objecttype, sar->pos.x, sar->pos.y, sar->vel.x, sar->vel.y, sar->radius, sar->prio);
	}
		
	printf("------------------------------------------------------\n");	
	printf("Typ: %d, x(%.0f, %.0f), v(%.0f, %.0f), rad: %d, view(%.0f, %.0f)\n", shp->objecttype, shp->pos.x, shp->pos.y, shp->vel.x, shp->vel.y, shp->radius, shp->view.x, shp->view.y);		
	printf("======================================================\n");	
}
			

void GameStatus::Update(ObjectManager* mgr, ObjectManager* objmgr) 
{
	mgr->Update(objmgr);
}

const char* ToString (GameStatus::State st)
{
	switch (st)
	{
		case GameStatus::unknown:
			return "unknown";
		case GameStatus::standby:
			return "standby";
		case GameStatus::prepare:
			return "prepare";
		case GameStatus::playing:
			return "playing";
		case GameStatus::gameover:
			return "gameover";
		case GameStatus::highscore:
			return "highscore";
		default:
			return "state not set";
	}

	return "";
}


const char* ToString (GameStatus::Event e)
{
	static char result[256];

	result[0] = '\0';
	if (e & GameStatus::ship_lost)
		strcat (result, "ship_lost | ");
	if (e & GameStatus::asteroid_destroyed)
		strcat (result, "asteroid_destroyed | ");
	if (e & GameStatus::saucer_destroyed)
		strcat (result, "saucer_destroyed | ");
	if (e & GameStatus::ship_inhyperspace)
		strcat (result, "ship_inhyperspace | ");
	if (e & GameStatus::gamestart)
		strcat (result, "gamestart | ");
	if (e & GameStatus::nextlevel)
		strcat (result, "nextlevel | ");
	if (e & GameStatus::newlife)
		strcat (result, "newlife | ");
	if (e & GameStatus::state_changed)
		strcat (result, "state_changed | ");

	if (result[0] != '\0')
		result[strlen(result)-3] = '\0';

	return result;
}
