
#ifndef _GAMEOBJECT_H
#define _GAMEOBJECT_H

#include "konstanten.h"
#include "Types\vector2.h"
#include "console.h"

using std::vector;

class GameObject;
class Ship;

void ModuloScreen(Vector2* v, GameObject* enemy, Ship* ship);
void ModuloScreen(Vector2* v);

class GameObject
{
protected:	
	int avg_index;
	Vector2 avg[SPEED_AVERAGING];
	
public:
	GameObject();
	
	Vector2 pos;
	Vector2 temp;
	Vector2 vel;
	Vector2 force;
	int radius; // Radius: 10, 20 oder 40 pixel
	Vector2 dist;
	Vector2 att_dist;
	
	int prio;
	int points;
	int sf;
	int snipered;
	int age;
	int tag;
	
	float att_flighttime;
	float att_alpha;

	// wird beim Abgleich in GameObjects::Update() bentigt
	bool flagUpdate;
	int m_updates;
	int objecttype; // Objekttyp: Schiff, Asteroid, Ufo, Explosion, Shot
	
	void AutoIntegrationScheme(int frames);
	void PositionalUpdate(int x_new, int y_new);
	void PositionalUpdate(GameObject* g);
	void IntegrationScheme(int lostframes);
	void toFuture(int frames);
	char* putToString();
	Vector2* getAvg(int i);
	
};

class Asteroid : public GameObject
{
public:
	int type;		// 1 ... 4, uere Form

	Asteroid();
	Asteroid(int x, int y, int type, int scaleFactor);

	void set(int x, int y, int type, int sf);
	
};

class Explosion : public GameObject
{
public:
	int size;		// 0 (klein) ... 3 (gro), Gre

	Explosion();
	Explosion(int x, int y, int size, int scaleFactor);
		
	void set(int x, int y, int size, int sf);
};

class Saucer : public GameObject
{
public:
	int size;		// Gre: 15 = gro, 14 = klein, 0 = nicht sichtbar
	
	Saucer();
	Saucer(int x, int y, int size);
	
	bool IsPresent (void) const;
	void set(int x, int y, int size);
};

class Ship : public GameObject
{
protected:
	float winkel(int i);
	
public:
	int Winkelbyte;
	bool present;  // Schiff sichtbar
	Vector2 view;

	Ship();
	
	bool IsPresent (void) const;
	void ChangeWinkelbyte(int k);
	float omega();
	int calibrateWinkelbyteByView(int rotations);
	void set(int x, int y, int viewx, int viewy);
};

class Shot : public GameObject
{
public:
	Shot();
	Shot(int x, int y);

	void set(int x, int y);
};


// Winkelbyte
static vector<int>** wbyte = new vector<int>*[64]; // Anzahl Zeilen



#endif // _GAMEOBJECT_H
