// commonplayer.cpp: Beispielspieler fr Asteroids (Gemeinsame Funktionen)
// Matthias Fuchs
// Original: Harald Bgeholz / c't

#ifndef commonplayerH
#define commonplayerH

#include "math.h"
#include "Types\vector2.h"
#include <stdarg.h>

class GameObject;
class Ship;
class Asteroid;
class Saucer;
class ObjectManager;
class TaskList;

namespace CommonPlayer
{

void InitializeDistanceVectors(GameObject** closestObj, GameObject** attackObj, GameObject* currObj, Ship* ship, ObjectManager* objm, int* currPrio, int* currDist);
bool ObjectCentered(Vector2& pos, float ratio);
float CalculateLeadingShot(GameObject* obj1, Ship* obj2);
float FiringAccuracy(GameObject* obj);
void CalculateTargetPriority(GameObject* obj1, Ship* obj2, ObjectManager* objm);
float flybyDist(GameObject* obj, Ship* ship);
void SteerShipTo(const Vector2 target, Ship* ship, TaskList* sched);

} // end namespace


#endif
