package de.curdreinert.asteroids.intelligence;

import java.util.ArrayList;
import java.util.List;

import de.curdreinert.asteroids.base.Parameter;

public class History {

	private List<Screen> screens = new ArrayList<Screen>();

	public void add(Screen screen) {
		screens.add(0, screen);
		if (screens.size() > Parameter.getScreenHistorySize()) {
			screens.remove(Parameter.getScreenHistorySize());
		}
	}

	public Screen getOldestScreenWithSameAsteroids(Screen asThis) {
		Screen result = null;
		for (int i = 0; i < screens.size()
				&& screens.get(i).sameAsteroids(asThis); i++) {
			result = screens.get(i);
		}
		return result;
	}

	public Screen last() {
		if (screens.size() == 0) {
			return null;
		}
		return screens.get(0);
	}

	public int size() {
		return screens.size();
	}

	public Screen getOldestScreenWithSameShots(Screen asThis) {
		Screen result = null;
		for (int i = 0; i < screens.size()
				&& screens.get(i).sameShots(asThis); i++) {
			result = screens.get(i);
		}
		return result;
	}
}
