package de.curdreinert.asteroids.geometry;

public class Vector {

	private double x;

	private double y;

	private double v;

	public Vector(double x, double y) {
		this.x = x;
		this.y = y;
		this.v = Math.sqrt(x * x + y * y);
	}

	public Vector(Position from, Position to) {
		this(from, to, 1);
	}

	public Vector(Position from, Position to, int frames) {
		this(normalize(to.getX() - from.getX(), 1024, frames), normalize(to
				.getY()
				- from.getY(), 768, frames));
	}

	private static double normalize(int delta, int width, int frames) {
		int raw = delta;
		if (delta > width / 2) {
			raw = width - delta;
		}
		return ((double) raw) / (double) frames;
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

	public double getLength() {
		return v;
	}

	public String toString() {
		return String.format("%.0f, %.0f, d=%.2f, %.2f", x, y, v, degree());
	}

	public double radians() {
		double result = Math.atan(((double) y) / ((double) x));
		if (x < 0) {
			result += Math.PI;
		}
		if (result < 0) {
			result += 2 * Math.PI;
		}
		return result;
	}

	public double degree() {
		return Math.toDegrees(radians());
	}

	public Vector multiply(double factor) {
		return new Vector(x * factor, y * factor);
	}
}
