package asteroid.strategy;

import junit.framework.TestCase;

public class DistanceTest extends TestCase {
	static final int MIN_SIZE = 15;
	static final int SIZE_GROSS = 8 * 40;
	static final int SIZE_MITTEL = 8 * 20;
	static final int SIZE_KLEIN = 8 * 10;

	public DistanceTest( String name) {
		super( name);
	}

	private static void analyseHit( double x1, double y1, double vx, double vy, double x2, double y2, double size) {
		double v = Math.sqrt( (vx * vx) + (vy * vy));
		double dx = x2 - x1;
		double dy = y2 - y1;
		double dist = Math.abs( (dx * vy) - (dy * vx)) / v;
		assertTrue( dist != 0);
		if ((Math.abs( dx) <= size) && (Math.abs( dy) <= size)) {
			double r = ((dx * vx) + (dy * vy)) / v;
			assertTrue( r != 0);
		}
		if ((vx >= 0) && (vy >= 0)) { // NO
			dx -= size;
			dy -= size;
			double r = ((dx * vx) + (dy * vy)) / v;
			assertTrue( r != 0);
		}
		if ((vx < 0) && (vy >= 0)) { // NW
			dx += size;
			dy -= size;
			double r = ((dx * vx) + (dy * vy)) / v;
			assertTrue( r != 0);
		}
		if ((vx < 0) && (vy < 0)) { // SW
			dx += size;
			dy += size;
			double r = ((dx * vx) + (dy * vy)) / v;
			assertTrue( r != 0);
		}
		if ((vx >= 0) && (vy < 0)) { // SO
			dx -= size;
			dy += size;
			double r = ((dx * vx) + (dy * vy)) / v;
			assertTrue( r != 0);
		}
	}

	private static boolean isHit( int x1, int y1, int vx, int vy, int x2, int y2, int size) {
		analyseHit( x1, y1, vx, vy, x2, y2, size);
		int dx = x2 - x1;
		int dy = y2 - y1;
		if ((Math.abs( dx) <= size) && (Math.abs( dy) <= size)) {
			return true;
		}
		if (vx >= 0) {
			dx -= size;
		}
		else {
			dx += size;
		}
		if (vy >= 0) {
			dy -= size;
		}
		else {
			dy += size;
		}
		return (Math.abs( dx) <= size) && (Math.abs( dy) <= size);
//		int dd = (dx * vy) - (dy * vx);
//		if (vx >= 0) {
//			dx -= size;
//		}
//		else {
//			dx += size;
//		}
//		if (vy >= 0) {
//			dy -= size;
//		}
//		else {
//			dy += size;
//		}
//		int dr = (dx * vx) + (dy * vy);
//		int vSqr = (vx * vx) + (vy * vy);
//		return (dr > 0) && (dr <= vSqr) && ((dd * dd) < (size * size * vSqr));
	}

	public void testE() {
		assertEquals( true, isHit( 5056, 1696, 21, -60, 5104, 1480, SIZE_GROSS));
		assertEquals( true, isHit( 4568, 2816, 17, -61, 4616, 2728, SIZE_GROSS));
		assertEquals( true, isHit( 3800, 5016, -27, 57, 3784, 5080, SIZE_KLEIN));
		assertEquals( true, isHit( 3552, 3608, -47, -43, 3392, 3472, SIZE_KLEIN));
		assertEquals( true, isHit( 1088, 5632, -58, 27, 1016, 5656, SIZE_KLEIN));
		assertEquals( true, isHit( 5200, 4888, 52, 36, 5160, 4968, SIZE_KLEIN));
		assertEquals( true, isHit( 3200, 4160, -64, -2, 3112, 4168, SIZE_KLEIN));
	}

	public void xtestA() {
		int x1 = 500;
		int y1 = 500;
		int vx = 10;
		int vy = 10;
		assertEquals( true, isHit( x1, y1, vx, vy, x1 + 5, y1 + 7, MIN_SIZE));
		assertEquals( true, isHit( x1, y1, vx, vy, x1 + 7, y1 + 5, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 + 10, y1 + 13, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 + 13, y1 + 10, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 + 5, y1 + 8, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 + 8, y1 + 5, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 - 1, y1 - 3, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 - 3, y1 - 1, MIN_SIZE));
	}

	public void xtestB() {
		int x1 = 500;
		int y1 = 500;
		int vx = -10;
		int vy = 10;
		assertEquals( true, isHit( x1, y1, vx, vy, x1 - 5, y1 + 7, MIN_SIZE));
		assertEquals( true, isHit( x1, y1, vx, vy, x1 - 7, y1 + 5, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 - 10, y1 + 13, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 - 13, y1 + 10, MIN_SIZE));
	}

	public void xtestC() {
		int x1 = 500;
		int y1 = 500;
		int vx = -10;
		int vy = -10;
		assertEquals( true, isHit( x1, y1, vx, vy, x1 - 5, y1 - 7, MIN_SIZE));
		assertEquals( true, isHit( x1, y1, vx, vy, x1 - 7, y1 - 5, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 - 10, y1 - 13, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 - 13, y1 - 10, MIN_SIZE));
	}

	public void xtestD() {
		int x1 = 500;
		int y1 = 500;
		int vx = 10;
		int vy = -10;
		assertEquals( true, isHit( x1, y1, vx, vy, x1 + 5, y1 - 7, MIN_SIZE));
		assertEquals( true, isHit( x1, y1, vx, vy, x1 + 7, y1 - 5, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 + 10, y1 - 13, MIN_SIZE));
		assertEquals( false, isHit( x1, y1, vx, vy, x1 + 13, y1 - 10, MIN_SIZE));
	}
}
