package asteroid.model;

import asteroid.strategy.Simple;

import junit.framework.TestCase;

public class AngleTest extends TestCase {
	private Ship mShip = new Ship();
	private Simple mSimple = new Simple( null, ICompute.KEY_LEFT);

	public AngleTest( String name) {
		super( name);
	}

	public void testA0() {
		int sx = 524;
		int sy = 524;
		for (int i = 0; i < 256; ++i) {
//			if (i % 16 == 0)
//				System.out.println();
			String msg = "angle:" + i;
			int bx = sx + (Angle.posShotX( i) >> 3);
			int by = sy + (Angle.posShotY( i) >> 3);
			int vx = Angle.vShotX( i);
			int vy = Angle.vShotY( i);
//			System.out.print( Angle.getMaxAngle( i) + ",");
			System.out.println( msg + "  ship:" + sx + ":" + sy + "  shot:" + bx + "," + by + "  speed8:" + vx + "," + vy);
			assertEquals( msg, i, (int) Math.floor( i));
			assertEquals( msg, i >> 1, (int) Math.floor( i / 2));
			assertEquals( msg, i >> 2, (int) Math.floor( i / 4));
			assertEquals( msg, (3 * (i >> 1)) >> 1, (int) Math.floor( i / 2) + (int) Math.floor( i / 4));
		}
		System.out.println();
	}

	public void testA1() {
		assertEquals( 0, Angle.getShipIndex( 1536, 0));
		assertEquals( 1, Angle.getShipIndex( 1528, 152));
		assertEquals( 2, Angle.getShipIndex( 1504, 296));
		assertEquals( 3, Angle.getShipIndex( 1472, 440));
		assertEquals( 4, Angle.getShipIndex( 1416, 584));
		assertEquals( 5, Angle.getShipIndex( 1360, 720));
		assertEquals( 6, Angle.getShipIndex( 1280, 856));
		assertEquals( 7, Angle.getShipIndex( 1192, 976));
		assertEquals( 8, Angle.getShipIndex( 1088, 1088));
		assertEquals( 9, Angle.getShipIndex( 976, 1192));
		assertEquals( 10, Angle.getShipIndex( 856, 1280));
		assertEquals( 11, Angle.getShipIndex( 720, 1360));
		assertEquals( 12, Angle.getShipIndex( 584, 1416));
		assertEquals( 13, Angle.getShipIndex( 440, 1472));
		assertEquals( 14, Angle.getShipIndex( 296, 1504));
		assertEquals( 15, Angle.getShipIndex( 152, 1528));
		assertEquals( 16, Angle.getShipIndex( 0, 1536));
		assertEquals( 17, Angle.getShipIndex( -152, 1528));
		assertEquals( 18, Angle.getShipIndex( -296, 1504));
		assertEquals( 19, Angle.getShipIndex( -440, 1472));
		assertEquals( 20, Angle.getShipIndex( -584, 1416));
		assertEquals( 21, Angle.getShipIndex( -720, 1360));
		assertEquals( 22, Angle.getShipIndex( -856, 1280));
		assertEquals( 23, Angle.getShipIndex( -976, 1192));
		assertEquals( 24, Angle.getShipIndex( -1088, 1088));
		assertEquals( 25, Angle.getShipIndex( -1192, 976));
		assertEquals( 26, Angle.getShipIndex( -1280, 856));
		assertEquals( 27, Angle.getShipIndex( -1360, 720));
		assertEquals( 28, Angle.getShipIndex( -1416, 584));
		assertEquals( 29, Angle.getShipIndex( -1472, 440));
		assertEquals( 30, Angle.getShipIndex( -1504, 296));
		assertEquals( 31, Angle.getShipIndex( -1528, 152));
		assertEquals( 32, Angle.getShipIndex( -1536, 0));
		assertEquals( 33, Angle.getShipIndex( -1528, -152));
		assertEquals( 34, Angle.getShipIndex( -1504, -296));
		assertEquals( 35, Angle.getShipIndex( -1472, -440));
		assertEquals( 36, Angle.getShipIndex( -1416, -584));
		assertEquals( 37, Angle.getShipIndex( -1360, -720));
		assertEquals( 38, Angle.getShipIndex( -1280, -856));
		assertEquals( 39, Angle.getShipIndex( -1192, -976));
		assertEquals( 40, Angle.getShipIndex( -1088, -1088));
		assertEquals( 41, Angle.getShipIndex( -976, -1192));
		assertEquals( 42, Angle.getShipIndex( -856, -1280));
		assertEquals( 43, Angle.getShipIndex( -720, -1360));
		assertEquals( 44, Angle.getShipIndex( -584, -1416));
		assertEquals( 45, Angle.getShipIndex( -440, -1472));
		assertEquals( 46, Angle.getShipIndex( -296, -1504));
		assertEquals( 47, Angle.getShipIndex( -152, -1528));
		assertEquals( 48, Angle.getShipIndex( 0, -1536));
		assertEquals( 49, Angle.getShipIndex( 152, -1528));
		assertEquals( 50, Angle.getShipIndex( 296, -1504));
		assertEquals( 51, Angle.getShipIndex( 440, -1472));
		assertEquals( 52, Angle.getShipIndex( 584, -1416));
		assertEquals( 53, Angle.getShipIndex( 720, -1360));
		assertEquals( 54, Angle.getShipIndex( 856, -1280));
		assertEquals( 55, Angle.getShipIndex( 976, -1192));
		assertEquals( 56, Angle.getShipIndex( 1088, -1088));
		assertEquals( 57, Angle.getShipIndex( 1192, -976));
		assertEquals( 58, Angle.getShipIndex( 1280, -856));
		assertEquals( 59, Angle.getShipIndex( 1360, -720));
		assertEquals( 60, Angle.getShipIndex( 1416, -584));
		assertEquals( 61, Angle.getShipIndex( 1472, -440));
		assertEquals( 62, Angle.getShipIndex( 1504, -296));
		assertEquals( 63, Angle.getShipIndex( 1528, -152));
	}

	public void testB() {
		Angle angle = new Angle( mShip);
		angle.synchronice( 0); // 156,157,158,159
		angle.synchronice( 0);
		angle.synchronice( 0);
		assertEquals( 156, Angle.sDirection);
		angle.getKey( mSimple.getKey());
		assertEquals( 159, Angle.sDirection);
		angle.synchronice( 0);
		assertEquals( 159, Angle.sDirection);
		angle.synchronice( 0);
		assertEquals( 159, Angle.sDirection);
	}

	public void testC() {
		Angle angle = new Angle( mShip);
		angle.synchronice( 0); // 201,202,203,204
		angle.synchronice( 0);
		angle.synchronice( 0);
		assertEquals( 201, Angle.sDirection);
		angle.getKey( mSimple.getKey());
		assertEquals( 204, Angle.sDirection);
		angle.synchronice( 0);
		assertEquals( 204, Angle.sDirection);
		angle.synchronice( 0);
		assertEquals( 204, Angle.sDirection);
		angle.getKey( mSimple.getKey());
		assertEquals( 207, Angle.sDirection);
		angle.synchronice( 0);
		assertEquals( 207, Angle.sDirection);
	}

	public void testD() {
		for (int i = -100000; i < 100000; ++i) {
			assertEquals( "for " + i, xNormRot( i), i & 0xFF);
		}
		for (int i = -100000; i < 100000; ++i) {
			assertEquals( "for " + i, xNormX8( i), i & 0x1FFF);
		}
//		for (int i = -100000; i < 100000; ++i) {
//			assertEquals( "for " + i, xNormY8( i), i & 0x17FF);
//		}
		for (int i = -100000; i < 100000; ++i) {
			assertEquals( "for " + i, xSignRot( i), ((i + 128) & 0xFF) - 128);
		}
		for (int i = -100000; i < 100000; ++i) {
			assertEquals( "for " + i, xSignX8( i), ((i + 4096) & 0x1FFF) - 4096);
		}
//		for (int i = -100000; i < 100000; ++i) {
//			assertEquals( "for " + i, xSignY8( i), ((i + 3072) & 0x17FF) - 3072);
//		}
	}

	public void testE() {
		int x1 = 5104;
		int y1 = 4248;
		int x2 = 5608;
		int y2 = 4280;
		int dx = x2 - x1;
		int dy = y2 - y1;
		System.out.println( (dx / 8) + "," + (dy / 8));
		System.out.println( Math.atan2( dy, dx));
		System.out.println( Math.atan2( 9, 63));
		System.out.println( Math.atan2( 4, 63));
		System.out.println( Math.atan2( dy, dx) * 180.0 / Math.PI);
		System.out.println( Math.atan2( dy, dx) * 128.0 / Math.PI);
		System.out.println();
	}

	public void testF() {
		int x1 = 5104;
		int y1 = 4320;
		int x2 = 6616;
		int y2 = 4344;
		int dx = x2 - x1;
		int dy = y2 - y1;
		System.out.println( dx + "," + dy);
		System.out.println( Math.atan2( dy, dx));
		System.out.println( Math.atan2( 10, 70));
		System.out.println( Math.atan2( dy, dx) * 180.0 / Math.PI);
		System.out.println( Math.atan2( dy, dx) * 128.0 / Math.PI);
		System.out.println();
	}

	public void testG() {
		int x1 = 5088;
		int y1 = 4392;
		int x2 = 7072;
		int y2 = 4840;
		int dx = x2 - x1;
		int dy = y2 - y1;
		System.out.println( Math.atan2( dy, dx));
		System.out.println( Math.atan2( 20, 68));
		System.out.println( Math.atan2( dy, dx) * 180.0 / Math.PI);
		System.out.println( Math.atan2( dy, dx) * 128.0 / Math.PI);
		System.out.println();
	}

	public static int xNormRot( int val) {
		while (val >= 256) {
			val -= 256;
		}
		while (val < 0) {
			val += 256;
		}
		return val;
	}

	public static int xNormX8( int val) {
		while (val >= 8192) { // 1024 * 8
			val -= 8192; // 1024 * 8
		}
		while (val < 0) {
			val += 8192; // 1024 * 8
		}
		return val;
	}

	public static int xNormY8( int val) {
		while (val >= 6144) { // 768 * 8
			val -= 6144; // 768 * 8
		}
		while (val < 0) {
			val += 6144; // 768 * 8
		}
		return val;
	}

	public static int xSignRot( int val) {
		while (val < -128) {
			val += 256;
		}
		while (val >= 128) {
			val -= 256;
		}
		return val;
	}

	public static int xSignX8( int val) {
		while (val < -4096) { // -512 * 8
			val += 8192; // 1024 * 8
		}
		while (val >= 4096) { // 512 * 8
			val -= 8192; // 1024 * 8
		}
		return val;
	}

	public static int xSignY8( int val) {
		while (val < -3072) { // -384 * 8
			val += 6144; // 768 * 8
		}
		while (val >= 3072) { // 384 * 8
			val -= 6144; // 768 * 8
		}
		return val;
	}
}
