package asteroid.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JComponent;

import asteroid.Player;
import asteroid.SimpleLogging;
import asteroid.model.FlyInfo;

public class TestView extends JComponent {
	private static final long serialVersionUID = -8920459208626166274L;
	private static final String TEST = Player.HOME + "hits.txt";
	private static final int WIDTH = 640;
	private static final int HEIGHT = 480;
	private static final int ZOOM = 4;
	private static final double SHIP_SIZE = 5.0;
//	private static final int FONT_SIZE = 9;
	private Vector mAsts = new Vector();
	private boolean mDrawShip, mDrawUfo;
//	private static final Color TEXT_COLOR = Color.WHITE;
//	private Font mFont = new Font( "Monospace", Font.PLAIN, FONT_SIZE);
	private Graphics mGraph;
	private FlyInfo mShip = new FlyInfo();
	private Vector mShots = new Vector();
	private FlyInfo mUfo = new FlyInfo();

	public TestView() {
		Dimension size = new Dimension( WIDTH, HEIGHT);
		setMaximumSize( size);
		setMinimumSize( size);
		setPreferredSize( size);
		setOpaque( true);
		setDoubleBuffered( true);
		mUfo.set( 0, 0, 0, 0, 0);
		mShip.set( 0, 0, 0, 0, 0);
		mAsts.clear();
		mShots.clear();
//		parseFile();
//		parse( "Frame 10779  S:4192,4192,12,0,0	  A17:4272,4376,15,10,-18");
	}

	void drawArc( FlyInfo info, int width, int height) {
		width *= ZOOM;
		height *= ZOOM;
		int xl = getScreenX8( info.getX8() - width);
		int xr = getScreenX8( info.getX8() + width);
		int yo = getScreenY8( info.getY8() - height);
		int yu = getScreenY8( info.getY8() + height);
		mGraph.drawArc( xl, yu, xr - xl, yo - yu, 0, 360);
		mGraph.setColor( Color.GREEN);
		mGraph.drawArc( getScreenX8( info.getX8()), getScreenY8( info.getY8()), 3, 3, 0, 360);
	}

	void drawArc1( FlyInfo info, int width, int height) {
		width *= ZOOM;
		height *= ZOOM;
		int xl = getScreenX8( info.getX8() + info.getMoveX8() - width);
		int xr = getScreenX8( info.getX8() + info.getMoveX8() + width);
		int yo = getScreenY8( info.getY8() + info.getMoveY8() - height);
		int yu = getScreenY8( info.getY8() + info.getMoveY8() + height);
		mGraph.drawArc( xl, yu, xr - xl, yo - yu, 0, 360);
	}

	void drawAsteroid( FlyInfo ast) {
		mGraph.setColor( Color.MAGENTA);
		switch (ast.getZ()) {
			case 0: // grosser Asteroid
				drawArc( ast, 160, 160);
				break;
			case 15: // mittlerer Asteroid
				drawArc( ast, 80, 80);
				break;
			case 14: // kleiner Asteroid
				drawArc( ast, 32, 32);
				break;
		}
//		drawVelocity( ast);
	}

	void drawBorder( FlyInfo info, int width, int height) {
		mGraph.setColor( Color.WHITE);
		int xl = getScreenX8( info.getX8() - width);
		int xr = getScreenX8( info.getX8() + width);
		int yo = getScreenY8( info.getY8() - height);
		int yu = getScreenY8( info.getY8() + height);
		mGraph.drawRect( xl, yu, xr - xl, yo - yu);
//		mGraph.drawRect( xl, yo, width, height);
	}

	void drawBorder1( FlyInfo info, int width, int height) {
		mGraph.setColor( Color.WHITE);
		int xl = getScreenX8( info.getX8() - width);
		int xr = getScreenX8( info.getX8() + width);
		int yo = getScreenY8( info.getY8() - height);
		int yu = getScreenY8( info.getY8() + height);
		mGraph.drawArc( xl, yu, xr - xl, yo - yu, 0, 360);
	}

	void drawShip( FlyInfo ship) {
		double dir = 0;
		int dx = (int) Math.round( SHIP_SIZE * ZOOM * Math.cos( dir));
		int dy = (int) Math.round( -SHIP_SIZE * ZOOM * Math.sin( dir));
		int x = getScreenX8( ship.getX8());
		int y = getScreenY8( ship.getY8());
		mGraph.setColor( Color.WHITE);
		mGraph.drawLine( x - dx - dy, y - dy + dx, x - dx + dy, y - dy - dx);
		mGraph.drawLine( x - dx + dy, y - dy - dx, x + dx + dx, y + dy + dy);
		mGraph.drawLine( x - dx - dy, y - dy + dx, x + dx + dx, y + dy + dy);
//		drawVelocity( ship);
		drawBorder( ship, 400, 400);
		drawBorder( ship, 240, 240);
		drawBorder( ship, 160, 160);
	}

	void drawShot( FlyInfo shot) {
		mGraph.setColor( Color.GREEN);
		drawArc( shot, 1, 1);
		drawVelocity( shot);
	}

	void drawUfo( FlyInfo ufo) {
		int dx = 0;
		int dy = 0;
		switch (ufo.getZ()) {
			case 15: // grosses UFO
				dx = 12;
				dy = 5;
				drawBorder1( ufo, 400, 400);
				drawBorder1( ufo, 240, 240);
				drawBorder1( ufo, 160, 160);
				break;
			case 14: // kleines UFO
				dx = 6;
				dy = 3;
				drawBorder1( ufo, 360, 360);
				drawBorder1( ufo, 200, 200);
				drawBorder1( ufo, 120, 120);
				break;
		}
		dx *= ZOOM;
		dy *= ZOOM;
		mGraph.setColor( Color.RED);
		int x = getScreenX8( ufo.getX8());
		int y = getScreenY8( ufo.getY8());
		mGraph.drawLine( x - dx + dy, y - dy, x + dx - dy, y - dy);
		mGraph.drawLine( x - dx, y, x + dx, y);
		mGraph.drawLine( x - dx + dy, y + dy, x + dx - dy, y + dy);
		mGraph.drawLine( x - dx, y, x - dx + dy, y + dy);
		mGraph.drawLine( x + dx - dy, y + dy, x + dx, y);
		dy <<= 1;
		mGraph.drawLine( x - dx, y, x - dx + dy, y - dy);
		mGraph.drawLine( x - dx + dy, y - dy, x + dx - dy, y - dy);
		mGraph.drawLine( x + dx - dy, y - dy, x + dx, y);
		drawVelocity( ufo);
	}

	void drawVelocity( FlyInfo info) {
		mGraph.setColor( Color.GRAY);
		int x0 = getScreenX8( info.getX8());
		int y0 = getScreenY8( info.getY8());
		int x1 = getScreenX8( info.getX8() + info.getMoveX8());
		int y1 = getScreenY8( info.getY8() + info.getMoveY8());
		mGraph.drawLine( x0, y0, x1, y1);
	}

	public void paint( Graphics g) {
//		g.setFont( mFont);
		g.setColor( Color.black);
		g.fillRect( 0, 0, getWidth(), getHeight());
//		g.setColor( TEXT_COLOR);
//		mFM = g.getFontMetrics( mFont);
		mGraph = g;
		if (mDrawShip) {
			drawShip( mShip);
		}
		if (mDrawUfo) {
			drawUfo( mUfo);
		}
		for (Iterator i = mAsts.iterator(); i.hasNext();) {
			drawAsteroid( (FlyInfo) i.next());
		}
		for (Iterator i = mShots.iterator(); i.hasNext();) {
			drawShot( (FlyInfo) i.next());
		}
	}

	void parse( String s) {
		int baseX = 10000;
		int baseY = 10000;
		StringTokenizer st = new StringTokenizer( s);
		if (!st.hasMoreTokens()) {
			return;
		}
		if (!"Frame".equals( st.nextToken())) { // "Frame"
			return;
		}
		st.nextToken(); // frameNr
		while (st.hasMoreTokens()) {
			String detect = st.nextToken();
			StringTokenizer dd = new StringTokenizer( detect, ":,");
			if (dd.countTokens() != 6) {
				continue;
			}
			String type = dd.nextToken();
			int x = Integer.parseInt( dd.nextToken().trim());
			int y = Integer.parseInt( dd.nextToken().trim());
			int z = Integer.parseInt( dd.nextToken().trim());
			int moveX = Integer.parseInt( dd.nextToken().trim());
			int moveY = Integer.parseInt( dd.nextToken().trim());
			if ("S".equals( type)) {
//				baseX = x;
//				baseY = y;
//				mShip.set( x - baseX, y - baseY, z, moveX, moveY);
//				mDrawShip = true;
			}
			else if ("U".equals( type) && (z == 15)) {
//				baseX = x;
//				baseY = y;
//				mUfo.set( x - baseX, y - baseY, z, moveX, moveY);
//				mDrawUfo = true;
			}
			else if ("U".equals( type) && (z == 14)) {
				baseX = x;
				baseY = y;
				mUfo.set( x - baseX, y - baseY, z, moveX, moveY);
				mDrawUfo = true;
			}
			else if (type.startsWith( "A") && (z == 0)) {
//				baseX = x;
//				baseY = y;
//				mAsts.add( new FlyInfo( x - baseX, y - baseY, z, moveX, moveY));
			}
			else if (type.startsWith( "A") && (z == 15)) {
//				baseX = x;
//				baseY = y;
//				mAsts.add( new FlyInfo( x - baseX, y - baseY, z, moveX, moveY));
			}
			else if (type.startsWith( "A") && (z == 14)) {
//				baseX = x;
//				baseY = y;
//				mAsts.add( new FlyInfo( x - baseX, y - baseY, z, moveX, moveY));
			}
			else if (type.startsWith( "M")) {
				mShots.add( new FlyInfo( x - baseX, y - baseY, z, moveX, moveY));
			}
		}
	}

	void parseFile() {
		try {
			File f = new File( TEST);
			BufferedReader is = new BufferedReader( new FileReader( f.getAbsoluteFile()));
			String s = null;
			while ((s = is.readLine()) != null) {
//				if ((s.indexOf( " A") >= 0) && (s.indexOf( " S") >= 0)) {
//					parse( s);
//				}
//				if ((s.indexOf( " A") >= 0) && (s.indexOf( " M") >= 0)) {
//					parse( s);
//				}
//				if ((s.indexOf( " A") >= 0) && (s.indexOf( " U") >= 0)) {
//					parse( s);
//				}
//				if ((s.indexOf( " S") >= 0) && (s.indexOf( " M") >= 0)) {
//					parse( s);
//				}
//				if ((s.indexOf( " S") >= 0) && (s.indexOf( " U") >= 0)) {
//					parse( s);
//				}
				if ((s.indexOf( " U") >= 0) && (s.indexOf( " M") >= 0)) {
					parse( s);
				}
			}
			is.close();
		}
		catch (Exception ex) {
			SimpleLogging.addException( ex);
		}
	}

	private static int getScreenX8( int x8) {
//		return (WIDTH * x8) >> 13;
		return (WIDTH >> 1) + ((ZOOM * WIDTH * x8) >> 13);
	}

	private static int getScreenY8( int y8) {
//		return (WIDTH * (7160 - y8)) >> 13;
		return (HEIGHT >> 1) - ((ZOOM * WIDTH * y8) >> 13);
	}
}
