package asteroid.udp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

import asteroid.SimpleLogging;

public class GameSaver implements Runnable {
	private FileChannel mChannel;
	private ByteBuffer mKey = ByteBuffer.allocate( 1);

	public GameSaver() {
		Runtime.getRuntime().addShutdownHook( new Thread( this));
	}

	private void close() {
		if (mChannel != null) {
			try {
				mChannel.close();
				mChannel = null;
			}
			catch (Exception ex) {
				System.err.println( "exception: " + ex.getMessage());
			}
		}
	}

	static ByteBuffer createHeader( InetAddress addr, int port) {
		ByteBuffer bb = ByteBuffer.allocate( 0x39);
		bb.order( ByteOrder.LITTLE_ENDIAN);
		bb.put( AHandler.CT_MAME.getBytes());
		bb.put( AHandler.CT_VERSION);
		bb.put( (byte) 0xd);
		bb.put( (byte) 0xa);
		bb.putShort( (short) 2);
		bb.putShort( (short) port);
		try {
			if (addr != null) {
				addr = InetAddress.getLocalHost();
			}
			bb.put( addr.getAddress());
		}
		catch (UnknownHostException ex) {
			SimpleLogging.addException( ex);
			bb.put( new byte[] { 127, 0, 0, 1 });
		}
		for (int i = 0; i < 8; ++i) {
			bb.put( (byte) 0);
		}
		byte[] name = AHandler.NAME.getBytes();
		bb.put( name);
		for (int i = name.length; i < 32; ++i) {
			bb.put( (byte) 0);
		}
		bb.clear();
		return bb;
	}

	public void setOutput( String file, InetAddress addr, int port) {
		close();
		try {
			FileOutputStream os = new FileOutputStream( file);
			mChannel = os.getChannel();
			mChannel.write( createHeader( addr, port));
		}
		catch (IOException ex) {
			SimpleLogging.addException( ex);
			close();
		}
	}

	public void run() {
		close();
	}

	public void writeData( ByteBuffer bb) {
		try {
			if (mChannel != null) {
				ByteBuffer bb1 = bb.duplicate();
				bb1.rewind().limit( AHandler.RAM_SIZE);
				mChannel.write( bb1);
			}
		}
		catch (Exception ex) {
			SimpleLogging.addException( ex);
			close();
		}
	}

	public void writeKey( int key) {
		try {
			if (mChannel != null) {
				mKey.clear();
				mKey.put( 0, (byte) key);
				mChannel.write( mKey);
			}
		}
		catch (Exception ex) {
			SimpleLogging.addException( ex);
			close();
		}
	}
}
