package asteroid.udp;

import java.net.InetAddress;
import java.nio.ByteBuffer;

public abstract class AHandler extends Thread {
	public static final String CT_MAME = "ctmame";
	public static final String CT_NAME = "ctname";
	public static final byte CT_VERSION = (byte) '2';
	public static final String NAME = "eraser";
	public static final int RAM_SIZE = 1024;
	public static final int FRAME_POS = RAM_SIZE;
	public static final int FRAME_PING = RAM_SIZE + 1;
	public static final int FRAME_SIZE = RAM_SIZE + 2;
	public static final int KEY_SIZE = 8;
	public static final int KEY_POS = KEY_SIZE - 2;
	public static final int KEY_PING = KEY_SIZE - 1;
	public static final long TIME_SLEEP = 16; // 16ms
	protected long mTime = System.currentTimeMillis();
	GameSaver mSaver = new GameSaver();
	private boolean mOpen = true;

	public AHandler( String name) {
		super( name);
		setDaemon( true);
		setPriority( MAX_PRIORITY);
	}

	public abstract void addKey( int key);

	public abstract void close();

	public void createOutput( String file, InetAddress addr) {
		mSaver.setOutput( file, addr, NetHandler.PORT);
	}

	public abstract ByteBuffer getNext( boolean blocked);

	void setOpen( boolean value) {
		mOpen = value;
	}

	public boolean isOpen() {
		return mOpen;
	}

	void sleep( int timeOut) {
		mTime += timeOut;
		long time = System.currentTimeMillis();
		long sleep = mTime - time;
		if (sleep > 0) {
			try {
				sleep( sleep);
			}
			catch (InterruptedException ex) {
				System.out.print( ex.getMessage());
			}
		}
	}
}
