package asteroid.strategy;

import asteroid.Operation;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Ship;

public class Distance {
	private double mAlpha;
	private int mDX0, mDY0;
	private AEnemy mEnemy;
	private boolean mLeft;
	private int mTimeMin2, mDistMin2;
	private int mTimeShot, mTimeEnemy, mTimeWait;

	public Distance( AEnemy enemy) {
		mEnemy = enemy;
	}

	public double getAlpha( double shipRad) {
		boolean left = Angle.signRot( mAlpha - shipRad) > 0;
		double alpha = mAlpha;
		for (int i = 0; i < 3; ++i) {
			alpha = nextAlpha( alpha, shipRad, left);
		}
		return alpha;
	}

	public int getDistMin2() {
		return mDistMin2;
	}

	public void moveTo( int shipDir, int steps) {
		int rotTime = Math.abs( steps);
		int shotDir = shipDir + (3 * steps);
		int dx = mDX0 + (rotTime * mEnemy.getMoveX8()) - Angle.posShotX( shotDir);
		int dy = mDY0 + (rotTime * mEnemy.getMoveY8()) - Angle.posShotY( shotDir);
		int ox = Angle.vShotX( shotDir);
		int oy = Angle.vShotY( shotDir);
		int dvx = mEnemy.getMoveX8() - ox;
		int dvy = mEnemy.getMoveY8() - oy;
		int det = (mEnemy.getMoveY8() * ox) - (mEnemy.getMoveX8() * oy);
		if (det == 0) {
			if ((dx * dvy) == (dy * dvx)) {
				mTimeEnemy = mTimeShot = -((dx * dvy) + (dy * dvx)) / dvx / dvy / 2;
			}
			else {
				mTimeEnemy = mTimeShot = Short.MAX_VALUE;
			}
			mTimeWait = 0;
		}
		else {
			mTimeEnemy = ((dx * oy) - (dy * ox)) / det;
			mTimeShot = ((dx * mEnemy.getMoveY8()) - (dy * mEnemy.getMoveX8())) / det;
//			mTimeWait = ((dx * dvy) - (dy * dvx)) / det;
			mTimeWait = mTimeShot - mTimeEnemy;
		}
		int dv2 = (dvx * dvx) + (dvy * dvy);
		int da = (dx * dvx) + (dy * dvy);
		if (da > 0) {
			mTimeMin2 = Short.MAX_VALUE;
		}
		else {
			mTimeMin2 = -da / dv2;
		}
		int dd = (dy * dvx) - (dx * dvy);
		mDistMin2 = dd * dd / dv2;
//		int a = (dx * dvy) - (dy * dvx);
//		int b = (mEnemy.getMoveX8() * dvy) - (mEnemy.getMoveY8() * dvx);
//		int dv = (int) (Math.sqrt( dv2) + 0.5);
//		int tw1 = (-a + (mEnemy.sizeX() * dv)) / b;
//		int tw2 = (-a - (mEnemy.sizeX() * dv)) / b;
//		int db = (mEnemy.getMoveX8() * dvx) + (mEnemy.getMoveY8() * dvy);
//		int t1 = -(da + (tw1 * db)) / dv2;
//		int t2 = -(da + (tw2 * db)) / dv2;
	}

	double nextAlpha( double alpha, double shipRad, boolean left) {
		int shotDir = Angle.getAngle( alpha);
		double sr = alpha - shipRad;
		if (left) {
			if (sr < -Angle.PI_05) {
				sr += Angle.PI_2;
			}
		}
		else {
			if (sr > Angle.PI_05) {
				sr -= Angle.PI_2;
			}
		}
		double stepsRad = Angle.toAngle( sr) / 3.0;
		double rotTime = Math.abs( stepsRad);
		double dx = mDX0 + (rotTime * mEnemy.getMoveX8()) - Angle.posShotX( shotDir);
		double dy = mDY0 + (rotTime * mEnemy.getMoveY8()) - Angle.posShotY( shotDir);
		double shotSpeed8 = Angle.vShot( shotDir);
		double gamma = Math.atan2( dy, dx);
		double dBG = mEnemy.getBetha() - gamma;
		double dAG = Math.asin( mEnemy.getVelocity8() * Math.sin( dBG) / shotSpeed8);
		if (dAG > Angle.PI_05) {
			dAG = Math.PI - dAG;
		}
		else if (dAG < -Angle.PI_05) {
			dAG = -Math.PI - dAG;
		}
		return dAG + gamma;
	}

	int getStep( double alpha, double shipRad) {
		double stepsRad = Angle.toAngle( Angle.signRot( alpha - shipRad)) / 3.0;
		if (mLeft) {
			stepsRad = Math.ceil( stepsRad);
		}
		else {
			stepsRad = Math.floor( stepsRad);
		}
		return (int) stepsRad;
	}

	public int getTimeEnemy() {
		return mTimeEnemy;
	}

	public int getTimeMin2() {
		return mTimeMin2;
	}

	public int getTimeShot() {
		return mTimeShot;
	}

	public int getTimeWait() {
		return mTimeWait;
	}

	public void setTo( Ship ship, int time, int hx, int hy) {
		mDX0 = Operation.normX8( mEnemy.getX8( time)) - ship.getX8() + hx;
		mDY0 = Operation.normY8( mEnemy.getY8( time)) - ship.getY8() + hy;
		mAlpha = Math.atan2( mDY0, mDX0);
		mLeft = (mDX0 * mEnemy.getMoveY8()) > (mDY0 * mEnemy.getMoveX8());
	}
}
