package asteroid.strategy;

import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.AsteroidVector;
import asteroid.model.GameModel;
import asteroid.model.Magazine;
import asteroid.model.Ufo;

public class ChargeSingle extends AStrategie {
	private int mDirection;
	private int mDirectionNext;
	private int mFill;
	private Magazine mMagazine = new Magazine();
	private AEnemy[] mNearest = new AEnemy[AsteroidVector.MAX_ASTEROIDS + 1];

	public ChargeSingle( GameModel model) {
		super( model);
	}

	private void addNearest( AEnemy enemy) {
		for (int i = 0; i < mFill; ++i) {
			AEnemy n = mNearest[i];
//			if (enemy.getDistRot() > n.getDistRot()) {
//				continue;
//			}
//			if ((enemy.getDistRot() == n.getDistRot()) && (enemy.getFireTime() > n.getFireTime())) {
//				continue;
//			}
			if (enemy.getTime() > n.getTime()) {
				continue;
			}
			System.arraycopy( mNearest, i, mNearest, i + 1, AsteroidVector.MAX_ASTEROIDS - i);
			mNearest[i] = enemy;
			++mFill;
			return;
		}
		mNearest[mFill++] = enemy;
	}

	public void cleanup() {
		mMagazine.cleanup( mModel);
	}

	public void forAsteroid( Asteroid ast) {
		forEnemy( ast);
	}

	private void forEnemy( AEnemy enemy) {
		if (enemy.isVisible()) {
			enemy.setDirection( mModel.getShip(), Angle.sForward);
			addNearest( enemy);
		}
	}

	public void forUfo( Ufo ufo) {
		forEnemy( ufo);
	}

	public int getKey() {
		if (mModel.isShipVisible()) {
			return getRot() | mMagazine.getKey();
		}
		else {
			return 0;
		}
	}

	private int getNextDirection( AEnemy enemy) {
		int dx = enemy.getX8() - mModel.getShip().getX8();
		int dy = enemy.getY8() - mModel.getShip().getY8();
		if (((dx * enemy.getMoveY8()) - (dy * enemy.getMoveX8())) > 0) {
			return enemy.getDirection() + 2;
		}
		else {
			return enemy.getDirection() - 2;
		}
	}

	public void refresh() {
		if (mModel.getShip().isVisible()) {
			mDirection = Angle.sDirection;
			mMagazine.prepareFire();
			mFill = 0;
			mModel.forUfo( this);
			mModel.forAllAsteroids( this);
			mDirectionNext = 99999;
			for (int i = 0; i < mFill; ++i) {
				AEnemy n = mNearest[i];
				if ((n.getTime() > 60.0) || (mMagazine.isTaget( n) && !n.canFire())) {
					continue;
				}
				if (Angle.distRot( n.getDirection() - Angle.sDirection) < 2) { // ich kann schiessen
					if (!n.canFire()) { // nur ein Schuss
						mMagazine.addFire( n, false);
						if ((n.getID() != Ufo.UFO_ID) && !n.canFire()) {
							n.initFire();
							switch (n.getZ()) {
								case 0: // grosser Asteroid
									if (mMagazine.isFire()) {
										mDirectionNext = getNextDirection( n);
									}
									break;
								case 15: // mittlerer Asteroid
									if (mMagazine.isFire()) {
										mDirectionNext = getNextDirection( n);
									}
									break;
								case 14: // kleiner Asteroid
									break;
							}
						}
					}
					else { // mehrere Schuesse
						mMagazine.addFire( n, true);
						if (mMagazine.isFire()) {
							n.decFire();
							mDirectionNext = getNextDirection( n);
						}
					}
				}
				else if (mDirectionNext == 99999) {
					mDirectionNext = n.getDirection();
				}
			}
			if (mDirectionNext == 99999) {
				mDirectionNext = (mFill > 0) ? mNearest[0].getDirection() : mDirection;
			}
			if ((mFill < 5) && (mFill > 0)) {
				for (int i = 0; i < mFill; ++i) {
					AEnemy n = mNearest[i];
					if (Angle.distRot( n.getDirection() - Angle.sDirection) < 1) {
						mMagazine.addFire( n, true);
					}
				}
			}
		}
	}

	private int getRot() {
		int dif = Angle.signRot( mDirectionNext - mDirection);
		if (dif > 1) {
			return KEY_LEFT;
		}
		if (dif < -1) {
			return KEY_RIGHT;
		}
		return 0;
	}
}
