package asteroid.strategy;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ufo;

public class Charge extends AStrategie {
	private int mDirectionNearest;
	private int mDist;
	private boolean mFire;
	private int mKey;

	public Charge( GameModel model) {
		super( model);
	}

	public void cleanup() {
	}

	private int getFire() {
		return mFire ? KEY_FIRE : 0;
	}

	public void forAsteroid( Asteroid ast) {
		if (ast.isVisible()) {
			ast.setDirection( mModel.getShip(), Angle.sForward);
			int best = ast.getDirection();
			if (Angle.distRot( best - Angle.sDirection) < 2) {
				mFire = true;
			}
			int dist = ast.getDistance2( mModel.getShip());
			if (dist < mDist) {
				mDist = dist;
				mDirectionNearest = best;
			}
		}
	}

	public void forUfo( Ufo ufo) {
		if (ufo.isVisible()) {
			ufo.setDirection( mModel.getShip(), Angle.sForward);
			int best = ufo.getDirection();
			if (Angle.distRot( best - Angle.sDirection) < 2) {
				mFire = true;
			}
			int dist = ufo.getDistance2( mModel.getShip());
			if (dist < mDist) {
				mDist = dist;
				mDirectionNearest = best;
			}
		}
	}

	public int getKey() {
		return mModel.isShipVisible() ? mKey : 0;
	}

	void print( AFlyable fly) {
		StringBuffer sb = new StringBuffer();
		sb.append( "Ship (").append( mModel.getShip().getX8()).append( ",").append( mModel.getShip().getY8()).append( ":").append( Angle.sDirection).append( ")");
		sb.append( " Flyable (").append( fly.getX8()).append( ",").append( fly.getY8()).append( ")");
		sb.append( " Move (").append( fly.getMoveX8()).append( ",").append( fly.getMoveY8()).append( ")");
		sb.append( " angle=").append( mDirectionNearest);
		sb.append( " v2=").append( fly.getVelocity8());
		System.out.println( sb.toString());
	}

	public void refresh() {
		if (mModel.getShip().isVisible()) {
			mDirectionNearest = Angle.sDirection;
			mDist = 0x7FFFFFFF;
			mFire = false;
			mModel.forUfo( this);
			mModel.forAllAsteroids( this);
			mKey = getRot() | getFire();
		}
	}

	private int getRot() {
		int dif = Angle.signRot( mDirectionNearest - Angle.sDirection);
		if (dif > 0) {
			return KEY_LEFT;
		}
		if (dif < 0) {
			return KEY_RIGHT;
		}
		return 0;
	}
}
