package asteroid.statistic;

import asteroid.model.GameModel;

public class GameValues {
	private AverageLong mCalcTime = new AverageLong( 5);
	private AverageLong mFrameTime = new AverageLong( 3);
	private long mPlayTime, mStartTime;

	public double getAverageFrames() {
		return 16000.0 / mFrameTime.getAverage();
	}

	public double getCalcTime() {
		return mCalcTime.getMean();
	}

	public void init() {
		long time = System.currentTimeMillis();
		mCalcTime.mStart = time;
		if ((GameModel.sFrame & 15) == 0) {
			mFrameTime.addDeviation( time);
			mFrameTime.mStart = time;
		}
	}

	public long getPlayTime() {
		return mPlayTime;
	}

	public void reset() {
		mCalcTime.mStart = mFrameTime.mStart = mStartTime = System.currentTimeMillis();
		mPlayTime = 0L;
	}

	public void update( GameModel model) {
		switch (model.getFrameType()) {
			case GameModel.FRAME_TYPE_READY:
			case GameModel.FRAME_TYPE_START:
				reset();
				break;
			case GameModel.FRAME_TYPE_GAME:
			case GameModel.FRAME_TYPE_GAME_OVER:
				updateTime( model);
				break;
			case GameModel.FRAME_TYPE_HIGH:
			case GameModel.FRAME_TYPE_END:
			case GameModel.FRAME_TYPE_SCORE:
				break;
		}
	}

	private void updateTime( GameModel model) {
		long time = System.currentTimeMillis();
		mCalcTime.addDeviation( time);
		if (model.isPlayTime()) {
			mPlayTime = time - mStartTime;
		}
	}
}
