package asteroid.printer;

import java.io.PrintStream;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class Shortly extends APrinter {
	private int mFrame;
	private GameModel mModel;

	public Shortly( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	public Shortly( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public void forAsteroid( Asteroid ast) {
		switch (ast.getState()) {
			case AFlyable.STATE_VISIBLE:
				forFlyable( "A" + ast.getIndex(), ast);
				break;
			case AFlyable.STATE_EXPLOSION:
				forFlyable( "E" + ast.getIndex(), ast);
				break;
			case AFlyable.STATE_BLOCKED:
				forFlyable( "e" + ast.getIndex(), ast);
				break;
			case AFlyable.STATE_HIDDEN:
				forFlyable( "a" + ast.getIndex(), ast);
		}
	}

	private void forFlyable( String ident, AFlyable fly) {
		mOut.savePos();
		mOut.print( ident);
		mOut.print( ':');
		if (fly != null) {
			printFlyable( fly);
		}
		mOut.fill( 28);
	}

	public void forShip( Ship ship) {
		switch (ship.getState()) {
			case AFlyable.STATE_VISIBLE:
				forFlyable( "S", ship);
				break;
			case AFlyable.STATE_EXPLOSION:
				forFlyable( "T", ship);
				break;
			case AFlyable.STATE_JUMP:
				forFlyable( "J", ship);
				break;
			case AFlyable.STATE_HIDDEN:
				forFlyable( "s", ship);
		}
	}

	public void forShot( Shot shot) {
		switch (shot.getState()) {
			case AFlyable.STATE_VISIBLE:
				forShot( "M" + shot.getIndex(), shot);
				break;
			case AFlyable.STATE_HIDDEN:
				forShot( "_" + shot.getIndex(), shot);
				break;
		}
	}

	private void forShot( String ident, Shot shot) {
		mOut.savePos();
		mOut.print( ident);
		mOut.print( ':');
		if (shot != null) {
			printFlyable( shot);
			if (shot.isVisible()) {
				if (shot.getHitTime() < 100) {
					mOut.print( ',');
					mOut.print( Math.round( 10.0 * shot.getHitTime()) / 10.0);
				}
//				mOut.print( shot.getLife());
			}
		}
		mOut.fill( 34);
	}

	public void forUfo( Ufo ufo) {
		switch (ufo.getState()) {
			case AFlyable.STATE_VISIBLE:
				forFlyable( "U", ufo);
				break;
			case AFlyable.STATE_EXPLOSION:
				forFlyable( "X", ufo);
				break;
			case AFlyable.STATE_HIDDEN:
				forFlyable( "u", ufo);
		}
	}

	public void print() {
		mOut.savePos();
		mOut.print( mFrame++);
		mOut.print( ',');
		mOut.printKey( Angle.sSendKey);
		mOut.print( ',');
		mOut.printByte( Angle.sReceivePing);
		mOut.print( ',');
		mOut.printByte( Angle.sSendPing);
		mOut.print( ',');
		mOut.printByte( Angle.sDirection);
		mOut.print( ',');
		mOut.print( Angle.sForward);
		int shipID = Angle.getShipIndex( mModel.getShip().getDx(), mModel.getShip().getDy());
		mOut.print( ',');
		mOut.printByte( Angle.getMinAngle( shipID));
		mOut.print( ',');
		mOut.printByte( Angle.getMaxAngle( shipID));
		mOut.fill( 36);
		mModel.forShip( this);
		mModel.forAllShots( this);
		mModel.forAllAsteroids( this);
		mModel.forUfo( this);
		mOut.println();
	}

	private void printFlyable( AFlyable fly) {
		mOut.printPos( fly.isHidden() ? 0 : fly.getX8());
		mOut.print( ',');
		mOut.printPos( fly.isHidden() ? 0 : fly.getY8());
		mOut.print( ',');
		mOut.printZoom( fly.getZ());
		mOut.print( ',');
		mOut.printSign( fly.isVisible() ? fly.getMoveX8() : 0);
		mOut.print( ',');
		mOut.printSign( fly.isVisible() ? fly.getMoveY8() : 0);
		mOut.print( ',');
		if (fly.getCreate() > 0) {
			mOut.print( fly.getCreate());
		}
		else {
			mOut.print( '.');
		}
		if (fly.getVanish() > 0) {
			mOut.print( fly.getVanish());
		}
		else {
			mOut.print( '.');
		}
	}
}
