package asteroid.printer;

import java.io.PrintStream;

import asteroid.Operation;
import asteroid.model.AEnemy;
import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class Printer extends APrinter {
	private GameModel mModel;
	private Ship mShip;

	public Printer( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	public Printer( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public void forAsteroid( Asteroid ast) {
		switch (ast.getState()) {
			case AFlyable.STATE_VISIBLE:
				forEnemy( ast.getIdent(), ast);
				break;
			case AFlyable.STATE_EXPLOSION:
				forEnemy( "E" + ast.getIndex(), ast);
				break;
		}
	}

	private void forEnemy( String ident, AEnemy enemy) {
		mOut.savePos();
		mOut.print( ident);
		mOut.print( ':');
		forFlyable( enemy);
		mOut.savePos();
		mOut.print( " fire=");
		mOut.print( enemy.getDirection());
		mOut.fill( 12);
		double betha = enemy.getBetha();
		mOut.print( " betha=");
		mOut.print( Math.round( 10000.0 * betha) / 10000.0);
		mOut.fill( 26);
		mOut.print( " gamma=");
		double gamma = enemy.getGamma();
		mOut.print( Math.round( 10000.0 * gamma) / 10000.0);
		mOut.fill( 40);
		mOut.print( " alpha=");
		mOut.print( Math.round( 10000.0 * enemy.getAlpha()) / 10000.0);
		mOut.fill( 54);
		double alpha = Angle.toRadiant( enemy.getAlpha());
		int dESx = Operation.signX8( enemy.getX8() - mShip.getX8() + (Angle.sForward * enemy.getMoveX8()));
		int dESy = Operation.signY8( enemy.getY8() - mShip.getY8() + (Angle.sForward * enemy.getMoveY8()));
		double dES = Math.sqrt( (dESx * dESx) + (dESy * dESy));
		double speedEnemy = enemy.getVelocity8();
		double temp = (Shot.SHIP_SHOT_SPEED8 * Math.cos( alpha - gamma)) - (speedEnemy * Math.cos( betha - gamma));
		double t = dES / temp;
		double dx = t * ((temp * Math.cos( gamma)) - ((Shot.SHIP_SHOT_SPEED8 * Math.cos( alpha)) - (speedEnemy * Math.cos( betha))));
		double dy = t * ((temp * Math.sin( gamma)) - ((Shot.SHIP_SHOT_SPEED8 * Math.sin( alpha)) - (speedEnemy * Math.sin( betha))));
		mOut.print( " dx=");
		mOut.print( Math.round( 100.0 * dx) / 100.0);
		mOut.fill( 68);
		mOut.print( " dy=");
		mOut.print( Math.round( 100.0 * dy) / 100.0);
		mOut.fill( 80);
		mOut.println();
	}

	private void forFlyable( AFlyable fly) {
		mOut.savePos();
		mOut.print( '(');
		mOut.print( fly.getX8());
		mOut.print( ',');
		mOut.print( fly.getY8());
		mOut.print( ',');
		mOut.print( fly.getZ());
		mOut.print( ')');
		mOut.fill( 14);
		mOut.print( '(');
		mOut.print( fly.getMoveX8());
		mOut.print( ',');
		mOut.print( fly.getMoveY8());
		mOut.print( ')');
//		mPrint.fill( 24);
//		mPrint.print( Math.round( 100.0 * Angle.getRoute( fly.getTheta())) / 100.0);
//		mPrint.fill( 30);
//		mPrint.print( Math.round( 100.0 * fly.getVelocity8()) / 100.0);
//		mPrint.fill( 40);
//		printArray( fly.getStepsX());
//		mPrint.fill( 70);
//		printArray( fly.getStepsY());
//		mPrint.fill( 100);
	}

	public void forShip( Ship ship) {
		mShip = ship;
		if (ship.isVisible()) {
			mOut.savePos();
			mOut.print( ship.getIdent());
			mOut.print( ':');
			forFlyable( ship);
			mOut.print( '(');
			mOut.print( ship.getDx());
			mOut.print( ',');
			mOut.print( ship.getDy());
			mOut.print( ')');
			mOut.println();
		}
	}

	public void forShot( Shot shot) {
		if (shot.isVisible()) {
			mOut.savePos();
			mOut.print( shot.getIdent());
			mOut.print( ':');
			forFlyable( shot);
			mOut.print( shot.isShip());
			mOut.println();
		}
	}

	public void forUfo( Ufo ufo) {
		switch (ufo.getState()) {
			case AFlyable.STATE_VISIBLE:
				forEnemy( ufo.getIdent(), ufo);
				break;
			case AFlyable.STATE_EXPLOSION:
				forEnemy( "X", ufo);
				break;
		}
	}

	public void print() {
		mOut.println();
		mOut.println( "Frame ");
		mOut.println( GameModel.sFrame);
		mOut.println( ", Direction=");
		mOut.println( Angle.sDirection);
		mModel.forShip( this);
		mModel.forUfo( this);
		mModel.forAllAsteroids( this);
		mModel.forAllShots( this);
	}

	void printArray( int[] arr) {
		mOut.print( '[');
		for (int i = 0; i < arr.length; ++i) {
			if (i > 0) {
				mOut.print( ',');
			}
			if (arr[i] >= 0) {
				mOut.print( ' ');
			}
			mOut.print( arr[i]);
		}
		mOut.print( ']');
	}
}
