package asteroid.printer;

import java.io.PrintStream;

import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;

public class Direction extends APrinter {
	private GameModel mModel;
	private int mShipX, mShipY;
	private int mShotX, mShotY;

	public Direction( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	public Direction( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public void forShip( Ship ship) {
		mShipX = ship.getX8();
		mShipY = ship.getY8();
	}

	public void forShot( Shot shot) {
		if (shot.getIndex() == 0) {
			if (shot.getCreate() > 0) {
				mShotX = shot.getX8();
				mShotY = shot.getY8();
			}
			if (shot.isVisible() && (shot.getModify() == 16)) {
				mOut.print( "A:");
				mOut.printByte( Angle.sDirection);
				mOut.print( ",");
				mOut.print( mShotX - mShipX);
				mOut.print( ",");
				mOut.print( mShotY - mShipY);
//				mOut.print( ",");
//				mOut.printSign( shot.getMoveX8());
//				mOut.print( ",");
//				mOut.printSign( shot.getMoveY8());
				mOut.println();
			}
		}
	}

	public void print() {
		mModel.forShip( this);
		mModel.forAllShots( this);
	}
}
