package asteroid.printer;

import java.io.PrintStream;

import asteroid.PrintWriterFormat;
import asteroid.model.ACompute;

public abstract class APrinter extends ACompute {
	protected PrintWriterFormat mOut;

	public APrinter( PrintStream ps) {
		mOut = new PrintWriterFormat( ps);
	}

	public APrinter( String file) {
		mOut = new PrintWriterFormat( file);
	}

	public APrinter( APrinter other) {
		mOut = other.mOut;
	}

	public PrintWriterFormat getOut() {
		return mOut;
	}

	public abstract void print();
}
