package asteroid.model;

import asteroid.Operation;

public class TargetInfo {
	private double mAlpha;
	private int mDirection, mRot, mWait;
	private int mFrameHit, mFrameShot;
	private boolean mLeftMove;
	private boolean mLeftRot;

	public void setAll( TargetInfo other) {
		mDirection = other.mDirection;
		mLeftMove = other.mLeftMove;
		mLeftRot = other.mLeftRot;
		mRot = other.mRot;
		mWait = other.mWait;
		mFrameHit = other.mFrameHit;
		mFrameShot = other.mFrameShot;
	}

	public double getAlpha() {
		return mAlpha;
	}

	void awayInit( int dx0, int dy0) {
//		boolean away = (dx0 * mEnemy.mMoveX8) > -(dy0 * mEnemy.mMoveY8);
	}

	public void calculate( AEnemy enemy, Ship ship, int shipDir, int refFrame, int primalFrame) {
		int time = refFrame - GameModel.sFrame + Angle.sForward;
		int hx = 0;
		int hy = 0;
		int dx0 = getX0( enemy, ship, time, hx);
		int dy0 = getY0( enemy, ship, time, hy);
		mLeftMove = (dx0 * enemy.mMoveY8) > (dy0 * enemy.mMoveX8);
		double shipRad = Angle.toRadiant( Angle.signRot( shipDir));
		mAlpha = Math.atan2( dy0, dx0);
//		for (int i = 0; i < 3; ++i) {
		nextAlpha( enemy, dx0, dy0, shipRad);
//		}
		double stepsRad = Angle.toAngle( Angle.signRot( mAlpha - shipRad)) / 3.0;
		mLeftRot = stepsRad >= 0;
		if (mLeftRot) {
			if (mLeftMove) {
				mRot = (int) Math.ceil( stepsRad);
			}
			else {
				mRot = (int) Math.floor( stepsRad);
			}
		}
		else {
			if (mLeftMove) {
				mRot = -(int) Math.ceil( stepsRad);
			}
			else {
				mRot = -(int) Math.floor( stepsRad);
			}
		}
		rotBest( enemy, dx0, dy0, shipDir, refFrame, primalFrame);
		setTimes( enemy, dx0, dy0, shipDir, refFrame);
	}

	public int getDirection() {
		return mDirection;
	}

	public int getFireTime() {
		return mFrameHit - mFrameShot;
	}

	public int getFrameHit() {
		return mFrameHit;
	}

	private void nextAlpha( AEnemy enemy, int dx0, int dy0, double shipRad) {
		int shotDir = Angle.getAngle( mAlpha);
		double sr = mAlpha - shipRad;
		if (Angle.signRot( mAlpha - shipRad) > 0) {
			if (sr < -Angle.PI_05) {
				sr += Angle.PI_2;
			}
		}
		else {
			if (sr > Angle.PI_05) {
				sr -= Angle.PI_2;
			}
		}
		double stepsRad = Angle.toAngle( sr) / 3.0;
		double timeRot = Math.abs( stepsRad) + Angle.sForward;
		double dx = dx0 + (timeRot * enemy.mMoveX8) - Angle.posShotX( shotDir);
		double dy = dy0 + (timeRot * enemy.mMoveY8) - Angle.posShotY( shotDir);
		double shotSpeed8 = Angle.vShot( shotDir);
		double gamma = Math.atan2( dy, dx);
		double dBG = enemy.getBetha() - gamma;
		double dAG = Math.asin( enemy.getVelocity8() * Math.sin( dBG) / shotSpeed8);
		if (dAG > Angle.PI_05) {
			dAG = Math.PI - dAG;
		}
		else if (dAG < -Angle.PI_05) {
			dAG = -Math.PI - dAG;
		}
		mAlpha = dAG + gamma;
	}

	public int getRot() {
		return mRot;
	}

	public int getRot( AEnemy enemy) {
		if (enemy.isVisible() && (mRot != 0)) {
			return mLeftRot ? ICompute.KEY_LEFT : ICompute.KEY_RIGHT;
		}
		return 0;
	}

	private int rotBackFar( AEnemy enemy, int dx0, int dy0, int shipDir, int wait) {
		while (mWait > Math.max( wait, 0)) { // zu lange warten --> zurueck drehen
			--mRot;
			++wait;
			mWait = twBetween( enemy, dx0, dy0, shipDir, wait);
		}
		return wait;
	}

	private int rotBackShort( AEnemy enemy, int dx0, int dy0, int shipDir, int wait) {
		while (mWait < 0) { // kein Schuss mehr moeglich --> zurueck drehen
			--mRot;
			++wait;
			mWait = twBetween( enemy, dx0, dy0, shipDir, wait);
		}
		return wait;
	}

	private void rotBest( AEnemy enemy, int dx0, int dy0, int shipDir, int refFrame, int primalFrame) {
		int wait = primalFrame - refFrame - mRot;
		mWait = twBetween( enemy, dx0, dy0, shipDir, wait);
		if (mLeftRot) {
			if (mLeftMove) {
				wait = rotBackFar( enemy, dx0, dy0, shipDir, wait);
				wait = rotForwardShort( enemy, dx0, dy0, shipDir, wait);
			}
			else {
				wait = rotForwardFar( enemy, dx0, dy0, shipDir, wait);
				wait = rotBackShort( enemy, dx0, dy0, shipDir, wait);
			}
		}
		else {
			if (mLeftMove) {
				wait = rotForwardFar( enemy, dx0, dy0, shipDir, wait);
				wait = rotBackShort( enemy, dx0, dy0, shipDir, wait);
			}
			else {
				wait = rotBackFar( enemy, dx0, dy0, shipDir, wait);
				wait = rotForwardShort( enemy, dx0, dy0, shipDir, wait);
			}
		}
		if (mWait < wait) {
			mWait = wait;
		}
		if (mRot < 0) {
			mLeftRot = !mLeftRot;
			mRot = -mRot;
		}
	}

	private int rotForwardFar( AEnemy enemy, int dx0, int dy0, int shipDir, int wait) {
		while (mWait > Math.max( wait, 0)) { // zu lange warten --> weiter drehen
			++mRot;
			--wait;
			mWait = twBetween( enemy, dx0, dy0, shipDir, wait);
		}
		return wait;
	}

	private int rotForwardShort( AEnemy enemy, int dx0, int dy0, int shipDir, int wait) {
		while (mWait < 0) { // kein Schuss mehr moeglich --> weiter drehen
			++mRot;
			--wait;
			mWait = twBetween( enemy, dx0, dy0, shipDir, wait);
		}
		return wait;
	}

	private int timeColl( AEnemy enemy, int dx0, int dy0) {
		int dvx = enemy.mMoveX8 - Angle.vShotX( mDirection);
		int dvy = enemy.mMoveY8 - Angle.vShotY( mDirection);
		int dv2 = (dvx * dvx) + (dvy * dvy);
		if (dv2 == 0) {
			return Short.MAX_VALUE;
		}
		int timeFly = mRot + mWait;
		int dx = dx0 + (timeFly * enemy.mMoveX8) - Angle.posShotX( mDirection);
		int dy = dy0 + (timeFly * enemy.mMoveY8) - Angle.posShotY( mDirection);
		int a = -((dx * dvx) + (dy * dvy));
		int b = (dx * dvy) - (dy * dvx);
		int c = (enemy.size() * enemy.size() * dv2) - (b * b);
		int d = (int) Math.sqrt( c + 0.5);
		int t1 = (a - d) / dv2;
		int t2 = (a + d) / dv2;
		if ((t1 < 0) && (t2 < 0)) {
			return Short.MAX_VALUE;
		}
		if (t1 < 0) {
			return t2;
		}
		if (t2 < 0) {
			return t1;
		}
		return (t1 < t2) ? t1 : t2;
	}

	private void setTimes( AEnemy enemy, int dx0, int dy0, int shipDir, int refFrame) {
		if (mLeftRot) {
			mDirection = shipDir + (3 * mRot);
		}
		else {
			mDirection = shipDir - (3 * mRot);
		}
		if (mWait < 0) {
			mWait = 0;
			mFrameShot = refFrame + mRot;
			mFrameHit = mFrameShot + Short.MAX_VALUE;
		}
		else {
			mFrameShot = refFrame + mRot + mWait;
			mFrameHit = mFrameShot + timeColl( enemy, dx0, dy0);
		}
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append( mLeftRot ? '+' : '-');
		sb.append( mRot);
		sb.append( ':');
		sb.append( mWait);
		sb.append( ':');
		sb.append( mFrameShot);
		sb.append( ':');
		sb.append( mFrameHit);
		return sb.toString();
	}

	private int twBetween( AEnemy enemy, int dx0, int dy0, int shipDir, int wait) {
		int shotDir;
		if (mLeftRot) {
			shotDir = shipDir + (3 * mRot);
		}
		else {
			shotDir = shipDir - (3 * mRot);
		}
		int ox = Angle.vShotX( shotDir);
		int oy = Angle.vShotY( shotDir);
		int c = (enemy.mMoveY8 * ox) - (enemy.mMoveX8 * oy);
		if (c == 0) {
			return 0;
		}
		int dvx = enemy.mMoveX8 - ox;
		int dvy = enemy.mMoveY8 - oy;
		int dv2 = (dvx * dvx) + (dvy * dvy);
		int dv = (int) Math.sqrt( dv2 + 0.5);
		int dx = dx0 + (mRot * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int dy = dy0 + (mRot * enemy.mMoveY8) - Angle.posShotY( shotDir);
		int a = (dy * dvx) - (dx * dvy);
		int b = enemy.size() * dv;
		int tw1 = (a - b) / c;
		int tw2 = (a + b) / c;
		if (wait < 0) {
			wait = 0;
		}
		if (tw1 < tw2) {
			if (tw2 < 0) {
				return -1; // tw1 < tw2 < 0; Enemy schon vorbei
			}
			if (tw2 < wait) { // tw1 < tw2 < wait; Enemy noch nicht bereit
				return tw2;
			}
			if (wait < tw1) { // wait < tw1 < tw2; Enemy noch zu weit weg
				return tw1;
			}
			return wait; // tw1 < wait < tw2; optimal
		}
		else {
			if (tw1 < 0) {
				return -1; // tw2 < tw1 < 0; Enemy schon vorbei
			}
			if (tw1 < wait) { // tw2 < tw1 < wait; Enemy noch nicht bereit
				return tw1;
			}
			if (wait < tw2) { // wait < tw2 < tw1; Enemy noch zu weit weg
				return tw2;
			}
			return wait; // tw2 < wait < tw1; optimal
		}
	}

	public int getWait() {
		return mWait;
	}

	public static int getX0( AEnemy enemy, Ship ship, int time, int hx) {
		return Operation.signX8( enemy.getX8( time) - ship.mX8) + hx;
	}

	public static int getY0( AEnemy enemy, Ship ship, int time, int hy) {
		return Operation.signY8( enemy.getY8( time) - ship.mY8) + hy;
	}
}
