package asteroid.model;

import java.io.PrintStream;

import asteroid.statistic.AverageInt;

public class Angle {
	private static final double SHIP_FACTOR = 32.0 / Math.PI;
	private static final double ANGLE_FACTOR = 128.0 / Math.PI;
	private static final double ROUTE_FACTOR = 180.0 / Math.PI;
	private static final double RAD_FACTOR = Math.PI / 128.0;
	public static final double PI_05 = Math.PI * 0.5;
	public static final double PI_2 = Math.PI * 2;
	public static int sDirection;
	public static double sRadiant;
	public static int sForward;
	public static int sReceivePing;
	public static int sSendPing;
	public static int sSendKey;
	public static final int[] MIN_ANGLE = new int[64];
	public static final int[] MAX_ANGLE = new int[64];
	public static final int[] COS_ASTEROID = new int[256];
	public static final int[] SIN_ASTEROID = new int[256];
	public static final int[] VX_SHOT = new int[256];
	public static final int[] VY_SHOT = new int[256];
	public static final double[] V_SHOT = new double[256];
	public static final int[] POSX_SHOT = {
			152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 144, 144, 144,
			144, 144, 136, 136, 136, 136, 128, 128, 128, 128, 120, 120, 120, 120, 112, 112,
			112, 104, 104, 96, 96, 96, 88, 88, 80, 80, 80, 72, 72, 64, 64, 56,
			56, 56, 48, 48, 40, 40, 32, 32, 24, 24, 16, 16, 8, 8, 0, 0,
			0, -8, -8, -16, -16, -24, -32, -32, -40, -40, -40, -48, -48, -56, -56, -64,
			-64, -72, -72, -80, -80, -80, -88, -88, -96, -96, -96, -104, -104, -112, -112, -112,
			-120, -120, -120, -120, -128, -128, -128, -136, -136, -136, -144, -144, -144, -144, -152, -152,
			-152, -152, -152, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160,
			-160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -152, -152,
			-152, -152, -152, -144, -144, -144, -144, -136, -136, -136, -128, -128, -128, -120, -120, -120,
			-120, -112, -112, -112, -104, -104, -96, -96, -96, -88, -88, -80, -80, -80, -72, -72,
			-64, -64, -56, -56, -48, -48, -40, -40, -40, -32, -32, -24, -16, -16, -8, -8,
			0, 0, 0, 8, 8, 16, 16, 24, 24, 32, 32, 40, 40, 48, 48, 56,
			56, 56, 64, 64, 72, 72, 80, 80, 80, 88, 88, 96, 96, 96, 104, 104,
			112, 112, 112, 120, 120, 120, 120, 128, 128, 128, 128, 136, 136, 136, 136, 144,
			144, 144, 144, 144, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152
		};
	public static final int[] POSY_SHOT = {
			0, 0, 0, 8, 8, 16, 16, 24, 24, 32, 32, 40, 40, 48, 48, 56,
			56, 56, 64, 64, 72, 72, 80, 80, 80, 88, 88, 96, 96, 96, 104, 104,
			112, 112, 112, 120, 120, 120, 120, 128, 128, 128, 128, 136, 136, 136, 136, 144,
			144, 144, 144, 144, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 144, 144, 144,
			144, 144, 136, 136, 136, 136, 128, 128, 128, 128, 120, 120, 120, 120, 112, 112,
			112, 104, 104, 96, 96, 96, 88, 88, 80, 80, 80, 72, 72, 64, 64, 56,
			56, 56, 48, 48, 40, 40, 32, 32, 24, 24, 16, 16, 8, 8, 0, 0,
			0, -8, -8, -16, -16, -24, -32, -32, -40, -40, -40, -48, -48, -56, -56, -64,
			-64, -72, -72, -80, -80, -80, -88, -88, -96, -96, -96, -104, -104, -112, -112, -112,
			-120, -120, -120, -120, -128, -128, -128, -136, -136, -136, -144, -144, -144, -144, -152, -152,
			-152, -152, -152, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160,
			-160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -152, -152,
			-152, -152, -152, -144, -144, -144, -144, -136, -136, -136, -128, -128, -128, -120, -120, -120,
			-120, -112, -112, -112, -104, -104, -96, -96, -96, -88, -88, -80, -80, -80, -72, -72,
			-64, -64, -56, -56, -48, -48, -40, -40, -40, -32, -32, -24, -16, -16, -8, -8
		};

	// astcos(w) = round( 127 * cos( angle * pi / 128)).
	// astsin(w) = round( 127 * sin( angle * pi / 128)).
	// vx = floor( astcos( w) / 2)
	// vy = floor( astsin( w) / 2)
	// px = floor(astcos(w)/2) + floor(astcos(w)/4)
	// py = floor(astsin(w)/2) + floor(astsin(w)/4)
	static {
		for (int i = 0; i < 256; ++i) {
			COS_ASTEROID[i] = (int) Math.round( 127.0 * Math.cos( toRadiant( i)));
			SIN_ASTEROID[i] = (int) Math.round( 127.0 * Math.sin( toRadiant( i)));
			VX_SHOT[i] = COS_ASTEROID[i] >> 1;
			VY_SHOT[i] = SIN_ASTEROID[i] >> 1;
			V_SHOT[i] = Math.sqrt( (VX_SHOT[i] * VX_SHOT[i]) + (VY_SHOT[i] * VY_SHOT[i]));
//			POSX_SHOT[i] = pos34( COS_ASTEROID[i] >> 1);
//			POSY_SHOT[i] = pos34( SIN_ASTEROID[i] >> 1);
//			int px = (int) Math.round( 151.0 * Math.cos( i * RAD_FACTOR));
//			int py = (int) Math.round( 151.0 * Math.sin( i * RAD_FACTOR));
//			POSX_SHOT[i] = (px + 3) & -8;
//			POSY_SHOT[i] = (py + 3) & -8;
		}
		for (int i = 0; i < 64; ++i) {
			MIN_ANGLE[i] = minAngle( i);
			MAX_ANGLE[i] = maxAngle( i);
		}
	}

	private int[] mAngle = new int[256];
	private int mExpected;
	private AverageInt mForward = new AverageInt( 3);
	private Ship mShip;

	Angle( Ship ship) {
		mShip = ship;
	}

	public static int getAngle( double rad) {
		return (int) Math.round( toAngle( rad)) & 0xFF;
	}

	public static int getAngle( int dx, int dy) {
		return getAngle( Math.atan2( dy, dx));
	}

	public static int cosA( int angle) {
		return COS_ASTEROID[angle & 0xFF];
	}

	public static int distRot( int val) {
		return Math.abs( signRot( val));
	}

	int getFireDirection() {
		return mAngle[(sSendPing - sForward) & 0xFF] & 0xFF;
	}

	void initDirection() {
		for (int i = 0; i < 256; ++i) {
			mAngle[i] = sDirection;
		}
	}

	int getKey( int key) {
		if (key != ICompute.KEY_NAME) {
			if ((key & ICompute.KEY_LEFT) != 0) {
				mAngle[sSendPing] += 3;
			}
			if ((key & ICompute.KEY_RIGHT) != 0) {
				mAngle[sSendPing] -= 3;
			}
		}
		sSendKey = key;
		return key | (sSendPing << 16);
	}

	public static int getMaxAngle( int val) {
		return MAX_ANGLE[val & 0x3F];
	}

	private static int maxAngle( int val) {
		if (val < 16) {
			return (val << 2) + 3;
		}
		if (val < 32) {
			return (val << 2);
		}
		if (val < 48) {
			return (val << 2) + 3;
		}
		return val << 2;
	}

	public static int getMinAngle( int val) {
		return MIN_ANGLE[val & 0x3F];
	}

	private static int minAngle( int val) {
		if (val > 48) {
			return (val << 2) - 3;
		}
		if (val > 32) {
			return val << 2;
		}
		if (val > 16) {
			return (val << 2) - 3;
		}
		if (val > 0) {
			return val << 2;
		}
		return -3;
	}

	public static int getMoveX( double move, int angle) {
		return (int) Math.round( move * Math.cos( toRadiant( angle)));
	}

	public static int getMoveY( double move, int angle) {
		return (int) Math.round( move * Math.sin( toRadiant( angle)));
	}

	public static int pos34( int val) {
		return val + (val >> 1);
	}

	public static int posShotX( int angle) {
		return POSX_SHOT[angle & 0xFF];
	}

	public static int posShotY( int angle) {
		return POSY_SHOT[angle & 0xFF];
	}

	void print( PrintStream ps, int ping, int min, int max) {
		ps.print( GameModel.sFrame);
		ps.print( " ");
		ps.print( sSendPing);
		ps.print( " ");
		ps.print( ping);
		ps.print( " (");
		ps.print( min);
		ps.print( ",");
		ps.print( max);
		ps.print( ") >> ");
		ps.print( "[");
		ps.print( mAngle[sSendPing] & 0xFF);
		ps.print( "]");
		for (int i = 1; i < 10; ++i) {
			int pos = (sSendPing - i) & 0xFF;
			ps.print( (pos == ping) ? "[" : " ");
			ps.print( mAngle[pos] & 0xFF);
			ps.print( (pos == ping) ? "]" : " ");
		}
		ps.println();
	}

	public static int getShipIndex( int x, int y) {
		return 0x3F & (int) Math.round( Math.atan2( y, x) * SHIP_FACTOR);
	}

	public static int shotLimit( int v) {
		if (v > 111) {
			return 111;
		}
		if (v < -111) {
			return -111;
		}
		return v;
	}

	public static int signRot( int val) {
		while (val < -128) {
			val += 256;
		}
		while (val > 128) {
			val -= 256;
		}
		return val;
//		return ((val + 128) & 0xFF) - 128;
	}

	public static double signRot( double val) {
		while (val < -Math.PI) {
			val += PI_2;
		}
		while (val > Math.PI) {
			val -= PI_2;
		}
		return val;
	}

	public static int sinA( int angle) {
		return SIN_ASTEROID[angle & 0xFF];
	}

	void synchronice( int ping) {
		sReceivePing = ping;
		if (ping == 0) {
			mExpected = (mExpected + 1) & 0xFF;
		}
		else {
			mForward.setValue( ping, (sSendPing - ping + 1) & 0xFF);
			mExpected = (ping + 1) & 0xFF;
		}
		sForward = mForward.getAverage();
		if (mShip.isVisible()) {
			int shipID = getShipIndex( mShip.getDx(), mShip.getDy());
			int last = (sSendPing - sForward) & 0xFF;
			int dir = mAngle[last];
			int min = MIN_ANGLE[shipID];
			int max = MAX_ANGLE[shipID];
			int dMin = signRot( min - dir);
			int dMax = signRot( max - dir);
			if (dMin > 0) {
				for (int i = 0; i < 256; ++i) {
					mAngle[i] += dMin;
				}
			}
			if (dMax < 0) {
				for (int i = 0; i < 256; ++i) {
					mAngle[i] += dMax;
				}
			}
		}
		int dir = mAngle[sSendPing];
		sSendPing = (sSendPing + 1) & 0xFF;
		mAngle[sSendPing] = dir;
		sDirection = dir & 0xFF;
		sRadiant = toRadiant( sDirection);
	}

	public static double toAngle( double rad) {
		return rad * ANGLE_FACTOR;
	}

	public static double toRadiant( double angel) {
		return angel * RAD_FACTOR;
	}

	public static double toRoute( double theta) {
		return theta * ROUTE_FACTOR;
	}

	public static double vShot( int angle) {
		return V_SHOT[angle & 0xFF];
	}

	public static int vShotX( int angle) {
		return VX_SHOT[angle & 0xFF];
	}

	public static int vShotY( int angle) {
		return VY_SHOT[angle & 0xFF];
	}
}
//  0, 1536,  0,	 253,254,255,0,1,2,3
//  1, 1528,  152,	 4,5,6,7
//  2, 1504,  296,	 8,9,10,11
//  3, 1472,  440,	 12,13,14,15
//  4, 1416,  584,	 16,17,18,19
//  5, 1360,  720,	 20,21,22,23
//  6, 1280,  856,	 24,25,26,27
//  7, 1192,  976,	 28,29,30,31
//  8, 1088,  1088,	 32,33,34,35
//  9, 976,   1192,	 36,37,38,39
// 10, 856,   1280,	 40,41,42,43
// 11, 720,	  1360,	 44,45,46,47
// 12, 584,	  1416,	 48,49,50,51
// 13, 440,	  1472,	 52,53,54,55
// 14, 296,	  1504,	 56,57,58,59
// 15, 152,	  1528,	 60,61,62,63
// 16, 0,	  1536,	 64
// 17, -152,  1528,	 65,66,67,68
// 18, -296,  1504,	 69,70,71,72
// 19, -440,  1472,	 73,74,75,76
// 20, -584,  1416,	 77,78,79,80
// 21, -720,  1360,	 81,82,83,84
// 22, -856,  1280,	 85,86,87,88
// 23, -976,  1192,	 89,90,91,92
// 24, -1088, 1088,	 93,94,95,96
// 25, -1192, 976,	 97,98,99,100
// 26, -1280, 856,	 101,102,103,104
// 27, -1360, 720,	 105,106,107,108
// 28, -1416, 584,	 109,110,111,112
// 29, -1472, 440,	 113,114,115,116
// 30, -1504, 296,	 117,118,119,120
// 31, -1528, 152,	 121,122,123,124
// 32, -1536, 0,	 125,126,127,128,129,130,131
// 33, -1528, -152,	 132,133,134,135
// 34, -1504, -296,	 136,137,138,139
// 35, -1472, -440,	 140,141,142,143
// 36, -1416, -584,	 144,145,146,147
// 37, -1360, -720,	 148,149,150,151
// 38, -1280, -856,	 152,153,154,155
// 39, -1192, -976,	 156,157,158,159
// 40, -1088, -1088, 160,161,162,163
// 41, -976,  -1192, 164,165,166,167
// 42, -856,  -1280, 168,169,170,171
// 43, -720,  -1360, 172,173,174,175
// 44, -584,  -1416, 176,177,178,179
// 45, -440,  -1472, 180,181,182,183
// 46, -296,  -1504, 184,185,186,187
// 47, -152,  -1528, 188,189,190,191
// 48, 0,	  -1536, 192
// 49, 152,	  -1528, 193,194,195,196
// 50, 296,	  -1504, 197,198,199,200
// 51, 440,	  -1472, 201,202,203,204
// 52, 584,	  -1416, 205,206,207,208
// 53, 720,	  -1360, 209,210,211,212
// 54, 856,	  -1280, 213,214,215,216
// 55, 976,	  -1192, 217,218,219,220
// 56, 1088,  -1088, 221,222,223,224
// 57, 1192,  -976,	 225,226,227,228
// 58, 1280,  -856,	 229,230,231,232
// 59, 1360,  -720,	 233,234,235,236
// 60, 1416,  -584,	 237,238,239,240
// 61, 1472,  -440,	 241,242,243,244
// 62, 1504,  -296,	 245,246,247,248
// 63, 1528,  -152,	 249,250,251,252
//
//A:000,152,0
//A:001,152,0
//A:002,152,0
//A:003,152,8
//A:004,152,8
//A:005,152,16
//A:006,152,16
//A:007,152,24
//A:008,152,24
//A:009,152,32
//A:010,152,32
//A:011,152,40
//A:012,152,40
//A:013,144,48
//A:014,144,48
//A:015,144,56
//A:016,144,56
//A:017,144,56
//A:018,136,64
//A:019,136,64
//A:020,136,72
//A:021,136,72
//A:022,128,80
//A:023,128,80
//A:024,128,80
//A:025,128,88
//A:026,120,88
//A:027,120,96
//A:028,120,96
//A:029,120,96
//A:030,112,104
//A:031,112,104
//A:032,112,112
//A:033,104,112
//A:034,104,112
//A:035,96,120
//A:036,96,120
//A:037,96,120
//A:038,88,120
//A:039,88,128
//A:040,80,128
//A:041,80,128
//A:042,80,128
//A:043,72,136
//A:044,72,136
//A:045,64,136
//A:046,64,136
//A:047,56,144
//A:048,56,144
//A:049,56,144
//A:050,48,144
//A:051,48,144
//A:052,40,152
//A:053,40,152
//A:054,32,152
//A:055,32,152
//A:056,24,152
//A:057,24,152
//A:058,16,152
//A:059,16,152
//A:060,8,152
//A:061,8,152
//A:062,0,152
//A:063,0,152
//A:064,0,152
//A:065,-8,152
//A:066,-8,152
//A:067,-16,152
//A:068,-16,152
//A:069,-24,152
//A:070,-32,152
//A:071,-32,152
//A:072,-40,152
//A:073,-40,152
//A:074,-40,152
//A:075,-48,152
//A:076,-48,152
//A:077,-56,144
//A:078,-56,144
//A:079,-64,144
//A:080,-64,144
//A:081,-72,144
//A:082,-72,136
//A:083,-80,136
//A:084,-80,136
//A:085,-80,136
//A:086,-88,128
//A:087,-88,128
//A:088,-96,128
//A:089,-96,128
//A:090,-96,120
//A:091,-104,120
//A:092,-104,120
//A:093,-112,120
//A:094,-112,112
//A:095,-112,112
//A:096,-120,112
//A:097,-120,104
//A:098,-120,104
//A:099,-120,96
//A:100,-128,96
//A:101,-128,96
//A:102,-128,88
//A:103,-136,88
//A:104,-136,80
//A:105,-136,80
//A:106,-144,80
//A:107,-144,72
//A:108,-144,72
//A:109,-144,64
//A:110,-152,64
//A:111,-152,56
//A:112,-152,56
//A:113,-152,56
//A:114,-152,48
//A:115,-160,48
//A:116,-160,40
//A:117,-160,40
//A:118,-160,32
//A:119,-160,32
//A:120,-160,24
//A:121,-160,24
//A:122,-160,16
//A:123,-160,16
//A:124,-160,8
//A:125,-160,8
//A:126,-160,0
//A:127,-160,0
//A:128,-160,0
//A:129,-160,-8
//A:130,-160,-8
//A:131,-160,-16
//A:132,-160,-16
//A:133,-160,-24
//A:134,-160,-32
//A:135,-160,-32
//A:136,-160,-40
//A:137,-160,-40
//A:138,-160,-40
//A:139,-160,-48
//A:140,-160,-48
//A:141,-160,-56
//A:142,-152,-56
//A:143,-152,-64
//A:144,-152,-64
//A:145,-152,-72
//A:146,-152,-72
//A:147,-144,-80
//A:148,-144,-80
//A:149,-144,-80
//A:150,-144,-88
//A:151,-144,-88
//A:152,-136,-96
//A:153,-136,-96
//A:154,-128,-96
//A:155,-128,-104
//A:156,-128,-104
//A:157,-120,-112
//A:158,-120,-112
//A:159,-120,-112
//A:160,-120,-120
//A:161,-112,-120
//A:162,-112,-120
//A:163,-112,-120
//A:164,-104,-128
//A:165,-104,-128
//A:166,-96,-128
//A:167,-96,-136
//A:168,-96,-136
//A:169,-88,-136
//A:170,-88,-144
//A:171,-80,-144
//A:172,-80,-144
//A:173,-80,-144
//A:174,-72,-152
//A:175,-72,-152
//A:176,-64,-152
//A:177,-64,-152
//A:178,-56,-152
//A:179,-56,-160
//A:180,-48,-160
//A:181,-48,-160
//A:182,-40,-160
//A:183,-40,-160
//A:184,-40,-160
//A:185,-32,-160
//A:186,-32,-160
//A:187,-24,-160
//A:188,-16,-160
//A:189,-16,-160
//A:190,-8,-160
//A:191,-8,-160
//A:192,0,-160
//A:193,0,-160
//A:194,0,-160
//A:195,8,-160
//A:196,8,-160
//A:197,16,-160
//A:198,16,-160
//A:199,24,-160
//A:200,24,-160
//A:201,32,-160
//A:202,32,-160
//A:203,40,-160
//A:204,40,-160
//A:205,48,-160
//A:206,48,-152
//A:207,56,-152 -77,53
//A:208,56,-152
//A:209,56,-152
//A:210,64,-152 -74,63
//A:211,64,-144
//A:212,72,-144
//A:213,72,-144 -70.48
//A:214,80,-144
//A:215,80,-136
//A:216,80,-136
//A:217,88,-136
//A:218,88,-128
//A:219,96,-128
//A:220,96,-128
//A:221,96,-120
//A:222,104,-120
//A:223,104,-120
//A:224,112,-120
//A:225,112,-112
//A:226,112,-112
//A:227,120,-112
//A:228,120,-104
//A:229,120,-104
//A:230,120,-96
//A:231,128,-96
//A:232,128,-96
//A:233,128,-88
//A:234,128,-88
//A:235,136,-80
//A:236,136,-80
//A:237,136,-80
//A:238,136,-72
//A:239,144,-72
//A:240,144,-64
//A:241,144,-64
//A:242,144,-56
//A:243,144,-56
//A:244,152,-48
//A:245,152,-48
//A:246,152,-40
//A:247,152,-40
//A:248,152,-40
//A:249,152,-32
//A:250,152,-32
//A:251,152,-24
//A:252,152,-16
//A:253,152,-16
//A:254,152,-8
//A:255,152,-8
