package asteroid.model;

import asteroid.Operation;

public abstract class AFlyable extends FlyInfo {
	public static final int STEP_SIZE = 8;
	public static final int STATE_HIDDEN = 0;
	public static final int STATE_VISIBLE = 1;
	public static final int STATE_EXPLOSION = 2;
	public static final int STATE_BLOCKED = 3;
	public static final int STATE_JUMP = 4;
	int mState, mCreate, mVanish;
	double mVelocity, mBetha;
	private int mLastFrame;
	private int mModify;
	private int[] mStepX = new int[STEP_SIZE];
	private int[] mStepY = new int[STEP_SIZE];

	AFlyable() {
	}

	AFlyable( int x8, int y8, int z, int moveX8, int moveY8) {
		super( x8, y8, z, moveX8, moveY8);
		mVelocity = Math.sqrt( (moveX8 * moveX8) + (moveY8 * moveY8));
		mBetha = Math.atan2( moveY8, moveX8);
	}

	final void addStep8( int x8, int y8) {
		int frameDiv = getFrameDistance();
		if (frameDiv > 0) {
			int dx = (Operation.signX8( x8 - mX8) >> 3) / frameDiv;
			int dy = (Operation.signY8( y8 - mY8) >> 3) / frameDiv;
			if ((Math.abs( dx) > 300) || (Math.abs( dy) > 300)) {
				dx += 0;
				dy += 0;
			}
			if ((mMoveX8 == 0) && (mMoveY8 == 0)) {
				initStep( dx, dy);
			}
			else {
				int index = GameModel.sFrame & 7;
				mMoveX8 -= mStepX[index];
				mMoveY8 -= mStepY[index];
				mMoveX8 += dx;
				mMoveY8 += dy;
				mStepX[index] = dx;
				mStepY[index] = dy;
				mBetha = Math.atan2( mMoveY8, mMoveX8);
				mVelocity = Math.sqrt( (mMoveX8 * mMoveX8) + (mMoveY8 * mMoveY8));
			}
			mCreate = 0;
		}
	}

	public final double getBetha() {
		return mBetha;
	}

	public final boolean isBlocked() {
		return mState == STATE_BLOCKED;
	}

	public final int getCreate() {
		return mCreate;
	}

	public final boolean isExplosion() {
		return mState == STATE_EXPLOSION;
	}

	final int getFrameDistance() {
		return GameModel.sFrame - mLastFrame;
	}

	public final boolean isHidden() {
		return mState == STATE_HIDDEN;
	}

	public abstract String getIdent();

	final void initStep( int dx, int dy) {
		mModify = 0;
		for (int i = 0; i < STEP_SIZE; ++i) {
			mStepX[i] = dx;
			mStepY[i] = dy;
		}
		mMoveX8 = dx << 3;
		mMoveY8 = dy << 3;
	}

	public final boolean isJump() {
		return mState == STATE_JUMP;
	}

	public final int getModify() {
		return mModify;
	}

	final void setPos8( int x8, int y8, int z) {
		mX8 = x8;
		mY8 = y8;
		mZ = z;
		mLastFrame = GameModel.sFrame;
		++mModify;
	}

	void set( int x8, int y8, int z, int moveX8, int moveY8, int state) {
		mX8 = x8;
		mY8 = y8;
		mZ = z;
		mMoveX8 = moveX8;
		mMoveY8 = moveY8;
		mCreate = (isHidden() && (state != STATE_HIDDEN)) ? 1 : 0;
		mVanish = (isVisible() && (state != STATE_VISIBLE)) ? 1 : 0;
		mState = state;
		if (state == STATE_VISIBLE) {
			++mModify;
		}
		else {
			mModify = 0;
		}
	}

	public abstract int size();

	public abstract int sizeX();

	public abstract int sizeY();

	public final int getState() {
		return mState;
	}

	public final int[] getStepsX() {
		return mStepX;
	}

	public final int[] getStepsY() {
		return mStepY;
	}

	public final int getVanish() {
		return mVanish;
	}

	public final int getVelocity28() {
		return (mMoveX8 * mMoveX8) + (mMoveY8 * mMoveY8);
	}

	public final double getVelocity8() {
		return mVelocity;
	}

	public final boolean isVisible() {
		return mState == STATE_VISIBLE;
	}
}
