/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy.measure;

import asteroid.Operation;
import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Ship;
import asteroid.strategy.measure.AMeasure;

public class Precision
extends AMeasure {
    private double mPrecWeight;
    private Ship mShip;

    public Precision(Ship ship, double d) {
        this.mShip = ship;
        this.mPrecWeight = d;
    }

    protected void measure(AEnemy aEnemy) {
        double d;
        double d2;
        int n = (aEnemy.getDirection() - Angle.sDirection) % 3;
        if (n == 2) {
            n = -1;
        }
        if ((d2 = this.getMinDist2(aEnemy.getDirection() + n, aEnemy)) > (d = (double)(aEnemy.sizeX() * aEnemy.sizeY()))) {
            aEnemy.mWeight += d2 * this.mPrecWeight;
        }
    }

    private double getMinDist2(int n, AEnemy aEnemy) {
        int n2;
        int n3 = Operation.signX8(aEnemy.getX8() - this.mShip.getX8() - Angle.posShotX(n));
        int n4 = Operation.signY8(aEnemy.getY8() - this.mShip.getY8() - Angle.posShotY(n));
        int n5 = aEnemy.getMoveX8() - Angle.vShotX(n);
        int n6 = n5 * n5 + (n2 = aEnemy.getMoveY8() - Angle.vShotY(n)) * n2;
        if (n6 == 0) {
            return 2.147483647E9;
        }
        double d = n3 * n2 - n4 * n5;
        return d * d / (double)n6;
    }

    protected void print(AEnemy aEnemy, PrintWriterFormat printWriterFormat) {
    }
}

