/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.Operation;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Ufo;
import asteroid.strategy.AStrategie;

public class DistanceDemo
extends AStrategie {
    private int mDist;
    private int mRot;
    private int mShipDX;
    private int mShipDY;
    private int mShipX;
    private int mShipY;

    public DistanceDemo(GameModel gameModel) {
        super(gameModel);
    }

    public void cleanup() {
    }

    public void forAsteroid(Asteroid asteroid) {
        if (asteroid.isVisible()) {
            int n = Operation.signX8(asteroid.getX8() - this.mShipX);
            int n2 = Operation.signY8(asteroid.getY8() - this.mShipY);
            int n3 = n * n + n2 * n2;
            switch (asteroid.getZ()) {
                case 0: {
                    n3 -= 102400;
                    break;
                }
                case 15: {
                    n3 -= 25600;
                    break;
                }
                case 14: {
                    n3 -= 4096;
                }
            }
            if (n3 < this.mDist) {
                this.mDist = n3;
                this.mRot = this.mShipDX * n2 - this.mShipDY * n;
            }
        }
    }

    public void forShip(Ship ship) {
        this.mShipX = ship.getX8();
        this.mShipY = ship.getY8();
        this.mShipDX = ship.getDx();
        this.mShipDY = ship.getDy();
    }

    public void forUfo(Ufo ufo) {
        if (ufo.isVisible()) {
            int n = Operation.signX8(ufo.getX8() - this.mShipX);
            int n2 = Operation.signY8(ufo.getY8() - this.mShipY);
            int n3 = n * n + n2 * n2;
            switch (ufo.getZ()) {
                case 15: {
                    n3 -= 15360;
                    break;
                }
                case 14: {
                    n3 -= 3840;
                }
            }
            if (n3 < this.mDist) {
                this.mDist = n3;
                this.mRot = this.mShipDX * n2 - this.mShipDY * n;
            }
        }
    }

    public int getKey() {
        int n = 0;
        if (this.mRot > 0) {
            n |= 0x10;
        }
        if (this.mRot < 0) {
            n |= 8;
        }
        if (this.mDist < 46656) {
            n |= 1;
        }
        if (this.mDist > 10240000) {
            n |= 4;
        }
        if (GameModel.sFrame % 2 == 0) {
            n |= 2;
        }
        return this.mModel.isShipVisible() ? n : 0;
    }

    public void refresh() {
        if (this.mModel.getShip().isVisible()) {
            this.mDist = Integer.MAX_VALUE;
            this.mModel.forShip(this);
            this.mModel.forAllAsteroids(this);
            this.mModel.forUfo(this);
        }
    }
}

