/*
 * Decompiled with CFR 0.152.
 */
package asteroid.statistic;

import asteroid.model.GameModel;
import asteroid.statistic.AverageLong;

public class GameValues {
    private AverageLong mCalcTime = new AverageLong(5);
    private AverageLong mFrameTime = new AverageLong(3);
    private long mPlayTime;
    private long mStartTime;

    public double getAverageFrames() {
        return 16000.0 / this.mFrameTime.getAverage();
    }

    public double getCalcTime() {
        return this.mCalcTime.getMean();
    }

    public void init() {
        long l;
        this.mCalcTime.mStart = l = System.currentTimeMillis();
        if ((GameModel.sFrame & 0xF) == 0) {
            this.mFrameTime.addDeviation(l);
            this.mFrameTime.mStart = l;
        }
    }

    public long getPlayTime() {
        return this.mPlayTime;
    }

    public void reset() {
        this.mFrameTime.mStart = this.mStartTime = System.currentTimeMillis();
        this.mCalcTime.mStart = this.mStartTime;
        this.mPlayTime = 0L;
    }

    public void update(GameModel gameModel) {
        switch (gameModel.getFrameType()) {
            case 1: 
            case 3: {
                this.reset();
                break;
            }
            case 4: 
            case 5: {
                this.updateTime(gameModel);
                break;
            }
        }
    }

    private void updateTime(GameModel gameModel) {
        long l = System.currentTimeMillis();
        this.mCalcTime.addDeviation(l);
        if (gameModel.isPlayTime()) {
            this.mPlayTime = l - this.mStartTime;
        }
    }
}

