/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.FlyInfo;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import java.io.PrintStream;

public class AnalyseHit1
extends APrinter {
    private GameModel mModel;

    public AnalyseHit1(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public AnalyseHit1(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
    }

    public void forAsteroid(Asteroid asteroid) {
        this.forFlyable(asteroid);
    }

    void forFlyable(AFlyable aFlyable) {
        if (aFlyable.getVanish() > 0) {
            this.mOut.savePos();
            this.mOut.print(aFlyable.getIdent());
            this.mOut.print(':');
            this.mOut.print(aFlyable.getX8());
            this.mOut.print(',');
            this.mOut.print(aFlyable.getY8());
            this.mOut.print(',');
            this.mOut.print(aFlyable.getZ());
            this.mOut.print(',');
            this.mOut.print(aFlyable.getMoveX8());
            this.mOut.print(',');
            this.mOut.print(aFlyable.getMoveY8());
            this.mOut.print(',');
            this.mOut.print(aFlyable.getVanish());
            this.mOut.fill(26);
        }
    }

    public void forShip(Ship ship) {
        this.forFlyable(ship);
    }

    public void forShot(Shot shot) {
        if (shot.getVanish() > 0) {
            this.mOut.savePos();
            this.mOut.print(shot.getIdent());
            this.mOut.print(':');
            FlyInfo flyInfo = shot.getLast();
            this.mOut.print(flyInfo.getX8());
            this.mOut.print(',');
            this.mOut.print(flyInfo.getY8());
            this.mOut.print(',');
            this.mOut.print(shot.getZ());
            this.mOut.print(',');
            this.mOut.print(flyInfo.getMoveX8());
            this.mOut.print(',');
            this.mOut.print(flyInfo.getMoveY8());
            this.mOut.print(',');
            this.mOut.print(shot.getVanish());
            this.mOut.fill(26);
        }
    }

    public void forUfo(Ufo ufo) {
        this.forFlyable(ufo);
    }

    public void print() {
        if (this.mModel.isVanished()) {
            this.mOut.savePos();
            this.mOut.print("Frame ");
            this.mOut.print(GameModel.sFrame);
            this.mOut.fill(16);
            this.mOut.fill(10);
            this.mModel.forShip(this);
            this.mModel.forUfo(this);
            this.mModel.forAllAsteroids(this);
            this.mModel.forAllShots(this);
            this.mOut.println();
        }
    }
}

