/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.SimpleLogging;
import asteroid.model.AFlyable;
import asteroid.model.ICompute;

public class Ship
extends AFlyable {
    private int mDetectShip;
    private int mDetectExplosion;
    private int mDx;
    private int mDy;
    private int mVx;
    private int mVy;

    Ship() {
        this.mState = 0;
    }

    Ship(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
        this.mState = 1;
    }

    void addExplosion(int n, int n2) {
        this.initStep(0, 0);
        this.setPos8(n << 3, n2 << 3, 12);
        ++this.mDetectExplosion;
    }

    void addShip(int n, int n2, int n3, int n4) {
        switch (this.mDetectShip) {
            case 0: {
                this.mVx = n3;
                this.mVy = n4;
                ++this.mDetectShip;
                break;
            }
            case 1: {
                n <<= 3;
                n2 <<= 3;
                switch (this.mState) {
                    case 0: 
                    case 4: {
                        this.mCreate = 1;
                        this.initStep(0, 0);
                        break;
                    }
                    case 1: {
                        this.addStep8(n, n2);
                        break;
                    }
                    default: {
                        SimpleLogging.addLog("illegal Ship state");
                    }
                }
                this.setPos8(n, n2, 12);
                this.mState = 1;
                this.mDx = this.mVx - n3;
                this.mDy = this.mVy - n4;
                ++this.mDetectShip;
            }
        }
    }

    void detect() {
        if (this.mDetectShip < 2) {
            int n = this.mVanish = this.mState == 1 ? 1 : 0;
            if (this.mDetectExplosion > 0) {
                this.mState = 2;
            } else {
                switch (this.mState) {
                    case 1: {
                        this.mState = 4;
                        break;
                    }
                    case 2: {
                        this.mState = 0;
                    }
                }
            }
        }
    }

    void doIt(ICompute iCompute) {
        iCompute.forShip(this);
    }

    public int getDx() {
        return this.mDx;
    }

    public int getDy() {
        return this.mDy;
    }

    public String getIdent() {
        return "S";
    }

    void prepare() {
        this.mDetectExplosion = 0;
        this.mDetectShip = 0;
        this.mVy = 0;
        this.mVx = 0;
        this.mVanish = 0;
    }

    void reset() {
        if (this.mDetectShip == 1) {
            this.mDetectShip = 0;
        }
    }

    public int size() {
        return 80;
    }

    public int sizeX() {
        return this.size();
    }

    public int sizeY() {
        return this.size();
    }

    public int getType() {
        return 2669;
    }
}

