/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.model.AEnemy;
import asteroid.model.ICompute;

public class Asteroid
extends AEnemy {
    public static final int MAX_FIRE_BIG = 1;
    public static final int MAX_FIRE_MEDIAN = 3;
    public static final int MAX_FIRE_SMALL = 1;
    public static final int EXPLOSION_COUNTDOWN = 37;
    public static final int[] EXPLOSION_SEQUENCE = new int[]{2176, 2176, 2176, 2176, 2198, 2198, 2198, 2198, 2229, 2229, 2229, 2229, 2256, 2256, 2256, 2176, 2176, 2198, 2198, 2229, 2229, 2256, 2256, 2176, 2198, 2198, 2229, 2256, 2176, 2198, 2229, 2256, 2176, 2198, 2256, 2176, 2229};
    int mCountDown;
    private String mIdent;
    private int mIndex;

    Asteroid(int n) {
        this.mIndex = n;
        this.mIdent = "A" + n;
    }

    Asteroid(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, n6);
        this.mIndex = n;
        this.mIdent = "A" + n;
    }

    void correctCD() {
        while (this.mCountDown > 0 && EXPLOSION_SEQUENCE[this.mCountDown - 1] != this.mType) {
            --this.mCountDown;
        }
    }

    void doIt(ICompute iCompute) {
        iCompute.forAsteroid(this);
    }

    public boolean isFired() {
        switch (this.mZ) {
            case 0: {
                return this.mFire < 1;
            }
            case 15: {
                return this.mFire < 3;
            }
            case 14: {
                return this.mFire < 1;
            }
        }
        return false;
    }

    public int getID() {
        return this.mIndex;
    }

    public String getIdent() {
        return this.mIdent;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void initFire() {
        switch (this.mZ) {
            case 0: {
                this.mFire = 1;
                break;
            }
            case 15: {
                this.mFire = 3;
                break;
            }
            case 14: {
                this.mFire = 1;
            }
        }
    }

    public int getScore() {
        switch (this.mZ) {
            case 0: {
                return 20;
            }
            case 15: {
                return 50;
            }
            case 14: {
                return 100;
            }
        }
        return 0;
    }

    public int size() {
        switch (this.mZ) {
            case 0: {
                return 250;
            }
            case 15: {
                return 120;
            }
            case 14: {
                return 50;
            }
        }
        return 0;
    }

    public int sizeX() {
        switch (this.mZ) {
            case 0: {
                return 320;
            }
            case 15: {
                return 160;
            }
            case 14: {
                return 80;
            }
        }
        return 0;
    }

    public int sizeY() {
        switch (this.mZ) {
            case 0: {
                return 320;
            }
            case 15: {
                return 160;
            }
            case 14: {
                return 80;
            }
        }
        return 0;
    }
}

