/* Routines to handle low level reading and interpreting of Vector RAM */
/* $Id: frame.c,v 1.4 2008/05/08 23:08:40 raap Exp $ */

#include <stdio.h>
#include <stdlib.h>

#include "frame.h"

/* check that coordinates are within bounds
	our assumption is that they run from 0..1023 in x direction and 0 .. 767 in y direction 
	TODO only useful in debugging
*/
static void ck(int x, int y){
	if ((x > 1023) || (x < 0) || (y > 767) || (y <0)){
		fprintf(stderr,"Screen coord. check failed for (%d,%d)\n", x, y);
		exit(20);
	}
};	

/* Initializes the FrameStatus structure */
static void 
frame_init(FrameStatus *frame)
{
	frame->ship_present = false;
	frame->saucer_present = false;
	frame->nasteroids = 0;
	frame->nshots = 0;
	frame->nufos = 0;
	frame->lives = 0;
	frame->score = 0;
}

static void set_asteroid(FrameStatus *frame, int x, int y, int type, int sf)
{
	frame->asteroids[frame->nasteroids].x = x;
	frame->asteroids[frame->nasteroids].y = y;
	frame->asteroids[frame->nasteroids].type = type;
	frame->asteroids[frame->nasteroids].sf = sf;
	frame->nasteroids++;
}

static void set_ufo(FrameStatus *frame, int x, int y, int sf){
	frame->ufos[frame->nufos].x = x;
	frame->ufos[frame->nufos].y = y;
	frame->ufos[frame->nufos].sf = sf;
	frame->nufos++;
}


static void set_shot(FrameStatus *frame, int x, int y){
	frame->shots[frame->nshots].x = x;
	frame->shots[frame->nshots].y = y;
	frame->nshots++;
}

/* Given a ROM address, TRUE iff it can be interpreted as a number */
static BOOL is_digit(int addr){
	if (addr == 0xadd) return TRUE; 	/* number 0 */
	if (addr == 0xb2c) return TRUE;		/* space = leading 0 */
	return ( (addr >=0xb2e) && (addr <= 0xb63));
};

/* Given a ROM address, returns the corresponding numeric digit */
static int rom2digit(addr) {
		switch (addr){
			case 0xb2e:
				return 1;
			case 0xb32:
				return 2;
			case 0xb3a:
				return 3;
			case 0xb41:
				return 4;
			case 0xb48:
				return 5;
			case 0xb4f:
				return 6;
			case 0xb56:
				return 7;
			case 0xb5b:
				return 8;
			case 0xb63:
				return 9;
			
			default:
				return 0;
		};
};

/* This function interprets a given frame (Vector RAM) 
	The gathered information is stored in the structure FrameStatus *frame)
*/

void 
InterpretScreen(FramePacket *packet, FrameStatus *frame)
{
	unsigned short *vector_ram = (unsigned short *)packet->vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;
	int multiplier = 10000;
	 
	frame_init(frame);
	if ((unsigned char)packet->vectorram[1] != 0xe0 && (unsigned char)packet->vectorram[1] != 0xe2){
		fprintf(stderr,"Unexpected first byte %02x in frame\n",(unsigned char)packet->vectorram[1]);
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
	};
	int pc = 1;
	for (;;) {
		int op = vector_ram[pc] >> 12;
		switch (op){
			
			case 0xa: // LABS
			/* This is the only point where we get absolut screen coordinates
				We adjust the y-coord so that it lies between 0 .. 767
			*/
				vy = (vector_ram[pc] & 0x3ff) - 128;
				vx = vector_ram[pc+1] & 0x3ff;
				vs = vector_ram[pc+1] >> 12;
				ck(vx, vy); /* TODO debug only */
			//fprintf(stderr,"LABS (%d,%d), s%d\n",vx, vy, vs);
				break;
			
				case 0xb: // HALT
					return;
			
					case 0xc: { 
						int addr = vector_ram[pc] & 0xfff;
						switch (addr) {
							case 0x852:
					//copyright text
								break;	
							case 0x880:
					//explosion 3
								break;						
							case 0x896:
					//explosion 2
								break;	
							case 0x8b5:
					//explosion 1
								break;	
							case 0x8d0:
					//explosion 0
								break;	
				
							case 0x8f3:
								set_asteroid(frame, vx, vy, 1, vs);
								break;
							case 0x8ff:
								set_asteroid(frame, vx, vy, 2, vs);
								break;
							case 0x90d:
								set_asteroid(frame, vx, vy, 3, vs);
								break;
				
							case 0x91a:
								set_asteroid(frame, vx, vy, 4, vs);
								break;
				
							case 0x929:
								if (frame->nufos > 0){
									fprintf(stderr,"More than 1 UFO present!\n");
									exit(20);
								};
								frame->saucer_present = true;
								set_ufo(frame, vx, vy, vs);
								break;

				
								case 0xa6d:	/* A ship template, used to indicate lives */
									frame->lives++;
									break;
				
							default:
								if ( is_digit(addr) ){
									/* We have a digit or space */
									if ( (vx == 100) && (vy == 748) ){
										/* The current score */
										frame->score += multiplier * rom2digit(addr);
										multiplier /= 10;
									};
								}	
									
								if ( (addr >= 0xa78) && (addr <= 0xb63) )
									break; /* Character or number */
								fprintf(stderr,"Jump to unknown subroutine %04x\n",addr);
								break;
						};
					};
					break;
				
					case 0xd: // RTSL
						return;
			
						case 0xe: // JMPL
			/*
							pc = vector_ram[pc] & 0xfff;
							break;
			*/
							fprintf(stderr,"Unhandled jump %04x\n",vector_ram[pc]);
							return;
			
							case 0xf: // SVEC
								dy = vector_ram[pc] & 0x300;
								if ((vector_ram[pc] & 0x400) != 0)
									dy = -dy;
			
								dx = (vector_ram[pc] & 0x03) << 8;
								if ((vector_ram[pc] & 0x04) != 0)
									dx = -dx;
			
								/* If we add 2 we get a scaling factor directly compatible with VCTR */
								sf = (((vector_ram[pc] & 0x08) >> 2) | ((vector_ram[pc] & 0x80) >> 11)) + 2;
			
								vz = (vector_ram[pc] & 0xf0) >> 4; /* visibility */
			//fprintf(stderr,"SVEC (%d, %d), s%d, z%d\n", dx, dy, sf, vz);
								break;
			
								default: /* really opcodes 0 to 9, VCTR opcodes */
									dy = vector_ram[pc] & 0x3ff;
									if ((vector_ram[pc] & 0x400) != 0)
										dy = -dy;
									dx = vector_ram[pc+1] & 0x3ff;
									if ((vector_ram[pc+1] & 0x400) != 0)
										dx = -dx;
									sf = op;
									vz = vector_ram[pc+1] >> 12;
			
			//fprintf(stderr,"VCTR (%d,%d), s%d, z%d\n",dx, dy, sf, vz);
			
									/* Do we have a point vector == shot ? */
									if ( (dx == 0) && (dy == 0) && (vz == 15)){
										set_shot(frame, vx, vy);
									};
			
			/* Now we try to detect the ship.
									The ship (and only the ship) always has exactly two vectors with visibility 12 and size 6 (really ?)
									These are the 2 big V shaped lines. 
									The last LABS before this should have told us the midpoint of the ship
									It is not really the midpoint, but somewhat off-center
									Maybe this is just the true point used in gameplay, or our shots are somewhat off
									TODO Find this out ! 
			*/   
									if ((sf == 6) && (vz == 12) && ((dx != 0) || (dy != 0)))
									{
										switch (shipdetect)
										{
										case 0:			/* first V - vector */
										v1x = dx;
										v1y = dy;
										++shipdetect;
										break;
										case 1:			/* second V - vector */
										frame->ship_present = true;
										frame->ship_x = vx;
										frame->ship_y = vy;
										frame->ship_dx = v1x - dx;
										frame->ship_dy = v1y - dy;
										++shipdetect;
					
										break;
										}
									}
									else if (shipdetect == 1){
										shipdetect = 0;
									};
			//if ((shipdetect == 2) && (vz == 0)) exit(20);
			
									break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}

