#include "g_state.h"
#include <map>
#include "consts.h"
#include <fstream>

using namespace std;

extern double shot_dir[];

class vs_state
{	public:
	int	x,y;
	int	gsf;
	vs_state()
	{	x=y=gsf=0;
	}
	void vctr(int dx,int dy,int sf)
	{	int rsf=512;
		int sfc=(sf+gsf)&0xf;
		while (sfc--) rsf>>=1;
		x+=dx/rsf;
		y+=dy/rsf;
	}	
	void labs(int x_,int y_,int gsf_)
	{       x=x_;
		y=y_;
		gsf=gsf_;
	}	
	void svec(int dx,int dy,int sf)
	{	int rsf=128;
		int sfc=(sf+gsf)&0xf;
		while (sfc--) rsf>>=1;
		x+=dx/rsf;
		y+=dy/rsf;
	}	
};

void mob::set_pos(const p2d &p)
{	old_pos.push(pos);
	if (old_pos.size()>QUEUE_SIZE)
		old_pos.pop();
	pos=p;
	dir=(pos-old_pos.front())/old_pos.size();
	updated=true;
	if (shot_at)
		shot_at--;
}		

class not_updated
{	public:
	bool operator () (const shot &s)
	{	return !s.updated;
	}
	bool operator () (const asteroid &a)
	{	return !a.updated;
	}
};	

class lifetime_is_zero
{	public:
	bool operator () (const pred_asteroid &a)
	{	return a.lifetime<=0;
	}
};	

g_state::g_state()
:ship(),saucer(),asteroids(),pred_asteroids(),shots(),targets(),message()
{	ship_present=false;
	saucer_present=false;
	lifes=0;
	score=0;
	ship_rotation_byte=0;
}

g_state::~g_state()
{	asteroids.clear();
	pred_asteroids.clear();
	shots.clear();
	targets.clear();
}

map<double,int>	shot_dist;

void g_state::interpret(unsigned char *vram,int frame_diff)
{	
	lifes=0;
	message.clear();
	score=0;

	list<asteroid>	nast;
	list<shot>	nshot;
	
	unsigned short int vr[512];
	for (int l=0; l<512; ++l)
		vr[l]=vram[2*l]+((vram[2*l+1])<<8);

	int pc=1;	// ignore first jump ???
	int dx,dy;
	int z;
	int sf;
	int addr;

	vs_state vs;

	bool halt=false;
	int ship_state=0;
	p2d ship_dir;
	p2d ship_pos;
	p2d shot_start;
	p2d saucer_pos;
	p2d saucer_dir;
	int saucer_size=0;
	int hs=0;	// score pos counter
	bool frame_has_saucer=false;
	bool frame_has_ship=false;
	p2d last_labs_pos;

	while (!halt)
	{	unsigned char op=vr[pc]>>12;
		if (op<=9)	// VCTR
		{       dy=vr[pc]&0x3ff; if (vr[pc]&0x400) dy=-dy;
			dx=vr[pc+1]&0x3ff; if (vr[pc+1]&0x400) dx=-dx;
			z=vr[pc+1]>>12;
			sf=op;
			if (dx==0 && dy==0 && z==15)
			{	nshot.push_back(shot(p2d(vs.x,vs.y)));
			}
			if (sf==6 && z==12)
			{	switch (ship_state)
				{       case 0 :
						ship_pos=last_labs_pos;
						ship_dir=p2d(dx,dy);
						shot_start=p2d(vs.x,vs.y)+p2d(dx,dy);
						ship_state++;
						break;
					case 1 :
						ship_dir+=-p2d(dx,dy);
						ship_state++;
						break;
					default :
						cerr << "ERROR: ship detection suspicious" << endl;
				}
				frame_has_ship=true;
			}	
			vs.vctr(dx,dy,sf);
			pc+=2;
		}
		else if (op==0xa) // labs
		{       dy=vr[pc]&0x3ff;
			dx=vr[pc+1]&0x3ff;
			sf=vr[pc+1]>>12;
			vs.labs(dx,dy,sf);
			pc+=2;
			if (dx==100 && dy==876)
			{	hs=5;
			}
			last_labs_pos=p2d(dx,dy);
		}	
		else if (op==0xb) // halt
		{	halt=true;
			pc++;
		}	
		else if (op==0xc)       // JSRL
		{	addr=vr[pc]&0xfff;
			pc++;
			switch (addr)
			{	case 0x8f3 :
					nast.push_back(asteroid(p2d(vs.x,vs.y),1,vs.gsf));
					break;
				case 0x8ff :
					nast.push_back(asteroid(p2d(vs.x,vs.y),2,vs.gsf));
					break;
				case 0x90d :
					nast.push_back(asteroid(p2d(vs.x,vs.y),3,vs.gsf));
					break;
				case 0x91a :
					nast.push_back(asteroid(p2d(vs.x,vs.y),4,vs.gsf));
					break;
				case 0x929 :
					if (saucer_present)
					{	saucer_dir=saucer_pos-p2d(vs.x,vs.y);
					}
					saucer_present=1;
					saucer_pos=p2d(vs.x,vs.y);
					saucer_size=vs.gsf;
					frame_has_saucer=true;
					break;
				case 0xA6D :
					lifes++;
					break;
				case 0xA78 : message+='A'; break;
				case 0xA80 : message+='B'; break;
				case 0xA8D : message+='C'; break;
				case 0xA93 : message+='D'; break;
				case 0xA9B : message+='E'; break;
				case 0xAA3 : message+='F'; break;
				case 0xAAA : message+='G'; break;
				case 0xAB3 : message+='H'; break;
				case 0xABA : message+='I'; break;
				case 0xAC1 : message+='J'; break;
				case 0xAC7 : message+='K'; break;
				case 0xACD : message+='L'; break;
				case 0xAD2 : message+='M'; break;
				case 0xAD8 : message+='N'; break;
				case 0xADD : message+='O'; if (hs) score*=10; break;
				case 0xAE3 : message+='P'; break;
				case 0xAEA : message+='Q'; break;
				case 0xAF3 : message+='R'; break;
				case 0xAFB : message+='S'; break;
				case 0xB02 : message+='T'; break;
				case 0xB08 : message+='U'; break;
				case 0xB0E : message+='V'; break;
				case 0xB13 : message+='W'; break;
				case 0xB1A : message+='X'; break;
				case 0xB1F : message+='Y'; break;
				case 0xB26 : message+='Z'; break;
				case 0xB2C : message+=' '; if (hs) ; break;
				case 0xB2E : message+='1'; if (hs) { score*=10; score+=1; } break;
				case 0xB32 : message+='2'; if (hs) { score*=10; score+=2; } break;
				case 0xB3A : message+='3'; if (hs) { score*=10; score+=3; } break;
				case 0xB41 : message+='4'; if (hs) { score*=10; score+=4; } break;
				case 0xB48 : message+='5'; if (hs) { score*=10; score+=5; } break;
				case 0xB4F : message+='6'; if (hs) { score*=10; score+=6; } break;
				case 0xB56 : message+='7'; if (hs) { score*=10; score+=7; } break;
				case 0xB5B : message+='8'; if (hs) { score*=10; score+=8; } break;
				case 0xB63 : message+='9'; if (hs) { score*=10; score+=9; } break;
			}
			if (hs) 
			{	hs--;
			}
		}	
		else if (op==0xd)
		{	pc++;
		}
		else if (op==0xe)
		{	addr=vr[pc]&0xfff;
			pc=addr;
		}	
		else if (op==0xf)
		{	dx=(vr[pc]&0x3)<<8; if (vr[pc]&0x4) dx=-dx;
			dy=vr[pc]&0x300; if (vr[pc]&0x400) dy=-dy;
			sf=0;
			if (vr[pc]&0x8) sf=2;
			if (vr[pc]&0x800) sf++;
			vs.svec(dx,dy,sf);
			pc++;
		}
	}
	if (frame_has_saucer)
	{	if (saucer_present)
		{	saucer.set_pos(saucer_pos);
		}
		else
		{	saucer_present=true;
			saucer=mob_saucer(saucer_pos,saucer_size);
		}
	}
	else
	{	saucer_present=false;
	}
	if (frame_has_ship)
	{	if (ship_present)
		{	ship.set_pos(ship_pos,ship_dir,shot_start);
		}
		else
		{	ship=mob_ship(ship_pos,ship_dir,shot_start);
			ship_present=true;
		}
	}	
	else
	{	ship_present=false;
	}
	// normalize to ship at 0,0
/*	p2d	offset(ship_pos);
	ship_pos-=offset;
	saucer_pos-=offset;
	for (list<asteroid>::iterator i=nast.begin(); i!=nast.end(); ++i)
		i->pos-=offset;
	for (list<shot>::iterator i=nshot.begin(); i!=nshot.end(); ++i)
		i->pos-=offset;
*/
	// update shots
	for (list<shot>::iterator i=shots.begin(); i!=shots.end(); ++i)
		i->updated=false;

	for (list<shot>::iterator i=shots.begin(); i!=shots.end(); ++i)
	{	p2d	e(i->pos);
		if (i->dir!=non_p2d)
			e+=i->dir;
		list<shot>::iterator ei=nshot.end();
		double	dist=10e10;
		for (list<shot>::iterator j=nshot.begin(); j!=nshot.end(); ++j)
		{	double d=p2d(e-j->pos).magnitude();
			if (d<dist)
			{	ei=j;
				dist=d;
			}	
		}
		if (dist<20.0)
		{	i->set_pos(ei->pos);
			nshot.erase(ei);
		}
	}
	list<shot>::iterator i=remove_if(shots.begin(),shots.end(),not_updated());
	if (i!=shots.end())
		shots.erase(i,shots.end());
	for (list<shot>::iterator j=nshot.begin(); j!=nshot.end(); ++j)
	{	shots.push_back(*j);
/*		shot_dist[p2d(j->pos-ship_pos).magnitude()]++;
		ofstream o("all_dump/shot_start_distance_to_ship_pos");
		for (map<double,int>::iterator i=shot_dist.begin(); i!=shot_dist.end(); ++i)
			o << i->first << '\t' << i->second << endl;
		o.close();	*/
	}	

	// update asteroids
	for (list<asteroid>::iterator i=asteroids.begin(); i!=asteroids.end(); ++i)
		i->updated=false;

	for (list<asteroid>::iterator i=asteroids.begin(); i!=asteroids.end(); ++i)
	{	p2d     e(i->pos);
		if (i->dir!=non_p2d)
			e+=i->dir;
		list<asteroid>::iterator ei=nast.end();	
		double  dist=10e10;
		for (list<asteroid>::iterator j=nast.begin(); j!=nast.end(); ++j)
		{       if (i->type!=j->type || i->sf!=j->sf)
				continue;
			double d=p2d(e-j->pos).magnitude();
			if (d<dist)
			{       ei=j;
				dist=d;
			}
		}
		if (dist<10.0)
		{	i->set_pos(ei->pos);
			nast.erase(ei);
		}
	}
	asteroids.erase(remove_if(asteroids.begin(),asteroids.end(),not_updated()),asteroids.end());
	for (list<asteroid>::iterator j=nast.begin(); j!=nast.end(); ++j)
		asteroids.push_back(*j);
	// update pred_asteroids
	for (list<pred_asteroid>::iterator i=pred_asteroids.begin(); i!=pred_asteroids.end(); ++i)
	{	if (i->shot_at)
			i->shot_at--;
		i->lifetime--;
	}		
	pred_asteroids.erase(remove_if(pred_asteroids.begin(),pred_asteroids.end(),lifetime_is_zero()),pred_asteroids.end());
}

ostream& operator << (ostream &o,const asteroid &a)
{	o << a.pos << " type " << a.type << " sf " << a.sf << " dir " << a.dir << " speed " << a.dir.magnitude() << " count_shots=" << a.count_shots;
	if (a.shot_at)
		o << " shot_at " << a.shot_at;
	return o;	
}

ostream& operator << (ostream &o,const pred_asteroid &a)
{	o << a.pos << " radius " << a.radius << " dir " << a.dir << " speed " << a.dir.magnitude() << " lifetime=" << a.lifetime;
	if (a.shot_at)
		o << " shot_at " << a.shot_at;
	return o;	
}
ostream& operator << (ostream &o,const shot &s)
{	return o << s.pos << " dir " << s.dir << " speed " << s.dir.magnitude(); 
}

ostream& operator << (ostream &o,const target &t)
{	return o << t.pos << " dir " << t.dir << " speed " << t.dir.magnitude() << " radius " << t.radius << " id=" << t.id; 
}

ostream& operator << (ostream &o,const g_state &g)
{	if (g.ship_present)
	{	o << "ship visible" << endl;
		o << "	pos " << g.ship.pos << endl;
		o << "	dir " << g.ship.dir << endl;
		o << "	pic_dir " << g.ship.pic_dir << endl;
		o << "	shot_start " << g.ship.shot_start << endl;
		p2d	s_dir(8,0);
		s_dir.rotate(-shot_dir[g.ship_rotation_byte]);
		o << "	shot_dir " << s_dir << endl;
	}	
	if (g.saucer_present)
	{	o << "saucer present" << endl;
		o << "	pos " << g.saucer.pos << endl;
		o << "	size " << g.saucer.size << endl;
		o << "	dir " << g.saucer.dir << endl;
		o << "	speed " << g.saucer.dir.magnitude() << endl;
		if (g.saucer.shot_at) 
			o << "	shot_at " << g.saucer.shot_at << endl;
	}	
	o << g.asteroids.size() << " asteroids" << endl;	
	for (list<asteroid>::const_iterator i=g.asteroids.begin(); i!=g.asteroids.end(); ++i)
		o << "	" << *i << endl;
	o << g.pred_asteroids.size() << " pred asteroids" << endl;
	for (list<pred_asteroid>::const_iterator i=g.pred_asteroids.begin(); i!=g.pred_asteroids.end(); ++i)
		o << "	" << *i << endl;
	o << g.shots.size() << " shots" << endl;
	for (list<shot>::const_iterator i=g.shots.begin(); i!=g.shots.end(); ++i)
		o << "	" << *i << endl;
	o << g.targets.size() << " targets" << endl;
	for (map<double,target>::const_iterator i=g.targets.begin(); i!=g.targets.end(); ++i)
		o << "	" << i->first << " " << i->second << endl;
	o << "lifes " << g.lifes << endl;
	o << "message '" << g.message << "'" << endl;
	o << "score " << g.score << endl;
	return o;
}

p2d get_hitting_shot(list<shot> &shots,const p2d &pos,const p2d &dir,int radius)
{	for (list<shot>::iterator i=shots.begin(); i!=shots.end(); ++i)
	{	double d=get_min_distance(i->pos,i->dir,pos,dir);
		if (d<radius)
		{	return i->pos;
		}
	}
	return non_p2d;
}

bool about_to_get_hit(list<shot> &shots,const p2d &pos,const p2d &dir,int radius)
{	for (list<shot>::iterator i=shots.begin(); i!=shots.end(); ++i)
	{	double d=get_min_distance(i->pos,i->dir,pos,dir);
		if (d<radius)
		{	shots.erase(i);
			return true;
		}
	}
	return false;
}

int count_possible_hits(list<shot> &shots,const p2d &pos,const p2d &dir,int radius)
{	int ret=0;
	for (list<shot>::iterator i=shots.begin(); i!=shots.end(); ++i)
	{	double d=get_min_distance(i->pos,i->dir,pos,dir);
		if (d<radius)
		{	shots.erase(i);
			ret++;
		}
	}
	return ret;
}

void g_state::compute_targets()
{	targets.clear();
	list<shot> s2(shots);

	int target_id=0;
	
	if (saucer_present && !saucer.shot_at && !about_to_get_hit(s2,saucer.pos,saucer.dir,(saucer.size==14)?SAUCER_RADIUS_14:SAUCER_RADIUS_15))
	{	double p=SAUCER_PRIORITY;
		p+=get_required_time(ship.pos,saucer.pos,saucer.dir);
		targets[p]=target(target_id,saucer.pos,saucer.dir,(saucer.size==14)?SAUCER_RADIUS_14:SAUCER_RADIUS_15,&saucer);
	}
	for (list<asteroid>::iterator i=asteroids.begin(); i!=asteroids.end(); ++i)
	{	
		int r=ASTRO_RADIUS_0;
		int ms=1;	// max shots
		switch (i->sf)
		{	case 0 : r=ASTRO_RADIUS_0; 
				ms=4;
				break;
			case 14 : r=ASTRO_RADIUS_14;
				ms=1;
				break;
			case 15 : r=ASTRO_RADIUS_15;
				ms=3;
				break;
		}
		if (i->shot_at==0)
			i->count_shots=0;
		if (i->count_shots>=ms)
			continue;

/*		if (i->predicted==false && (i->sf==0 || i->sf==15))
		{	p2d	shot_hit_pos(get_hitting_shot(s2,i->pos,i->dir,r));
			if (shot_hit_pos!=non_p2d)
			{	int new_r=ASTRO_RADIUS_14;
				if (i->sf==0)
					new_r=ASTRO_RADIUS_15;

				double	t=get_required_time(shot_hit_pos,i->pos,i->dir);
				p2d	hit(i->pos+i->dir*t);
				pred_asteroids.push_back(pred_asteroid(hit,p2d(),int(t),new_r));
				pred_asteroids.push_back(pred_asteroid(hit,p2d(),int(t),new_r));
				i->predicted=true;
			}
		}*/
		if (i->count_shots)
		{	if (r==ASTRO_RADIUS_0)
				r=ASTRO_RADIUS_15;
			if (r==ASTRO_RADIUS_15)
				r=ASTRO_RADIUS_14;
		}		
		if (!about_to_get_hit(s2,i->pos,i->dir,r))
		{	double d=get_min_distance(i->pos,i->dir,ship.pos,ship.dir);
			if (d>(r+SHIP_RADIUS))
			{	d=SAUCER_PRIORITY+get_time_to_hit(ship.pos,wb_to_dir(ship_rotation_byte),i->pos,i->dir,ASTRO_RADIUS_14);
			}
			else
			{	d=get_required_time(ship.pos,i->pos,i->dir);
			}
			targets[d]=target(target_id++,i->pos,i->dir,r,&(*i));
		}
		
	}
/*	for (list<pred_asteroid>::iterator i=pred_asteroids.begin(); i!=pred_asteroids.end(); ++i)
	{	if (i->shot_at)
			continue;
		double	t=get_required_time(ship.pos,i->pos,i->dir);	
		if (!about_to_get_hit(s2,i->pos,i->dir,i->radius))	
			targets[t]
				=target(target_id++,i->pos,i->dir,i->radius,&(*i));
	}*/
}	

double get_required_time(const p2d &shot_pos,const p2d &target_pos,const p2d &target_dir)
{	p2d	pos(shot_pos-target_pos);
	double	denom=64.0-target_dir.y*target_dir.y-target_dir.x*target_dir.x;
	double	p=2.0*(target_dir.x*pos.x+target_dir.y*pos.y)/denom;
	double	q=-(pos.x*pos.x+pos.y*pos.y)/denom;

	double x1=-p/2.0+sqrt(p*p/4-q);
	//double x2=-p/2.0-sqrt(p*p/4-q);
	return x1;
}

p2d get_required_shot_dir(const p2d &shot_pos,const p2d &target_pos,const p2d &target_dir)
{	p2d	pos(shot_pos-target_pos);
	double	t=get_required_time(shot_pos,target_pos,target_dir);
	return target_dir-pos/t;
}	

double get_distance_at_t(double t,const p2d &shot_pos,const p2d &shot_dir,const p2d &target_pos,const p2d &target_dir)
{	p2d x(shot_pos-target_pos+(shot_dir-target_dir)*t);
	return x.magnitude();
}

double get_min_distance(const p2d &shot_pos,const p2d &shot_dir,const p2d &target_pos,const p2d &target_dir)
{	p2d	z(shot_pos-target_pos);
	p2d	d(shot_dir-target_dir);
	double t=-(z.x*d.x+z.y*d.y)/(d.x*d.x+d.y*d.y);
	if (t<0)
		return 10e10;
	return get_distance_at_t(t,shot_pos,shot_dir,target_pos,target_dir);
}

#include "shot.inc"

p2d wb_to_dir(unsigned char x)
{	p2d ret(8,0);
	ret.rotate(-(2*M_PI*double(x)/double(256)));
	// ret.rotate(-shot_dir[x]);
	return ret;
}

unsigned char dir_to_wb(const p2d &d)
{	double w=atan2(d.y,d.x);
	if (w>0.0)
	{	return (unsigned char)(128.0*w/M_PI);
	}
	else
	{	return (unsigned char)(-128.0*-w/M_PI);
	}
}

pair<int,int> get_best_mapping(double x)
{	double dist=10e10;
	int	lo=0;
	int	hi=0;
	pair<int,int>	ret;
	for (unsigned int l=0; l<sizeof(dir_mapping)/sizeof(dir_mapping_struct); ++l)
	{	double d=fabs(dir_mapping[l].a-x);
		if (d<dist)
		{	dist=d;
			lo=dir_mapping[l].min;
			hi=dir_mapping[l].max;
		}
	}
	return pair<int,int>(lo,hi);
}	

unsigned char ub_diff(unsigned char a,unsigned char b)
{	unsigned char r1=a-b;
	unsigned char r2=b-a;
	return (r1<r2)?r1:r2;
}	

double get_time_to_hit(const p2d &shot_pos,const p2d &shot_dir_,const p2d &target_pos_,const p2d &target_dir,double radius)	
{	p2d shot_dir(shot_dir_);
	p2d target_pos(target_pos_);
	double	t=0;
	int loop=0;
	do
	{	double d=get_min_distance(shot_pos,shot_dir,target_pos,target_dir);
		p2d	req_shot_dir=get_required_shot_dir(shot_pos,target_pos,target_dir);
		double dt=ub_diff(dir_to_wb(shot_dir),dir_to_wb(req_shot_dir))/3.0;
		if ((d<radius || d>1E10) && dt<1.0)
			break;
		t+=dt;
		shot_dir=req_shot_dir;
		target_pos+=target_dir*dt;
	} while (loop++<20);
//if (loop>=20) cout << "loop overrun" << endl;	
	t+=get_required_time(shot_pos,target_pos,target_dir);
	return t;
}	

