#ifndef _AGENT_H_
#define _AGENT_H_

#pragma pack(1)
struct packet_frame
{	unsigned char vram[1024];
	unsigned char frameno;
	unsigned char ping;
};

#pragma pack(1)
class packet_keys
{	static const char KEY_HYPERSPACE=1;
	static const char KEY_FIRE=2;
	static const char KEY_THRUST=4;
	static const char KEY_RIGHT=8;
	static const char KEY_LEFT=0x10;
	static const char KEY_START=0x20;

	unsigned char signature[6];
	unsigned char keys;
	
	public:
	unsigned char ping;

	packet_keys();
	void clear();
	void hyperspace(bool);
	bool hyperspace();
	void fire(bool);
	void thrust(bool);
	void right(bool);
	void left(bool);
	void start(bool);
};	
#pragma pack()

class agent
{	int	sd;
	unsigned long server_ip;
	public:
	agent(int,unsigned long);
	void run();
	void receive(packet_frame&);
	void send(packet_keys&);
};

#endif

