// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.util.settings.StringPreferenceProperty;

import java.util.Locale;
import java.util.prefs.Preferences;

/**
 *  A preference property with a string value.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class SwingStringPreferenceProperty
        extends AbstractBasicSimpleEditablePreferenceProperty
        implements StringPreferenceProperty
{
  /** The string value. */
  private String value;

  /**
   *  Constructor.
   *  @param basicName  basic name
   *  @param baseTag    basic i18n tag
   */
  public SwingStringPreferenceProperty(String basicName, String baseTag)
  {
    super(basicName, baseTag);
  }

  /**
   * Read the property value from the preferences.
   *
   * @param preferences preferences from where to read the property value
   */
  public void readFrom(Preferences preferences)
  {
    setValue(preferences.get(getBasicName(), null));
  }

  /**
   * Store the current property value in the preferences.
   *
   * @param preferences preferences where to store the property value
   */
  public void storeTo(Preferences preferences)
  {
    if (value == null) {
      preferences.remove(getBasicName());
    }
    else {
      preferences.put(getBasicName(), value);
    }
  }

  /**
   * Get the editor components for editing this preference property.
   *
   * @param l locale used for i18n
   * @return editor component
   */
  public EditorProvider getEditorProvider(Locale l)
  {
    return new StringEditor(this, l);
  }

  /**
   *  Get the string value.
   *  @return string value
   */
  public String getValue()
  {
    return value;
  }

  /**
   *  Set the value.
   *  @param value  string value
   */
  public void setValue(String value)
  {
    if (value != null ? !value.equals(this.value) : this.value != null) {
      String oldValue = this.value;
      this.value = value;
      fireValueChange(getBasicName(), oldValue, value);
    }
  }
}
