// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

/**
 *  A editor provider for an integer value.
 *
 *  This uses a JSpinner to change the value. It allows for lower and upper bounds.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
class IntegerEditor
        extends AbstractBasicEditorProvider
        implements PropertyChangeListener
{
  /** The property to edit. */
  private final SwingIntegerPreferenceProperty propertySwing;
  /** Spinner used to display and set the property. */
  private final JSpinner spinner;

  /**
   *  Constructor.
   *  @param propertySwing property to handle
   *  @param l current locale
   */
  public IntegerEditor(SwingIntegerPreferenceProperty propertySwing, Locale l)
  {
    super(propertySwing, l);
    this.propertySwing = propertySwing;
    spinner = new JSpinner(new SpinnerNumberModel(propertySwing.getValue(),
                                                  propertySwing.getMinValue(),
                                                  propertySwing.getMaxValue(),
                                                  propertySwing.getStep()));
    // workaround for spinner being extremly wide (4541 pixels!)
    Dimension size = spinner.getPreferredSize();
    if (size.width > 1000) {
      spinner.setPreferredSize(new Dimension(100, size.height));
    }
    propertySwing.addValueChangeListener(this);
  }

  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return spinner;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  public void reset()
  {
    spinner.setValue(new Integer(propertySwing.getValue()));
  }

  /**
   * Set the basic value from the editor.
   */
  public void save()
  {
    propertySwing.setValue(((Number)spinner.getValue()).intValue());
  }

  /**
   * Called when the editor provider is no longer used.
   */
  public void goodBye()
  {
    propertySwing.removeValueChangeListener(this);
  }

  /**
   * This method gets called when a bound propertySwing is changed.
   *
   * @param evt A PropertyChangeEvent object describing the event source
   *            and the propertySwing that has changed.
   */

  public void propertyChange(PropertyChangeEvent evt)
  {
    int newValue = ((Number)evt.getNewValue()).intValue();
    if (newValue != ((Number)spinner.getValue()).intValue()) {
      spinner.setValue(evt.getNewValue());
    }
  }
}
