// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.util.settings.AbstractBasicLocalizablePreferenceProperty;

/**
 *  Basic implementation for simple editable preference properties.
 *  This takes care of i18n by trying to get the localized label,
 *  tooltip etc by adding the i18n suffix constants in 
 *  {@link I18n} to the basic tag.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
abstract class AbstractBasicSimpleEditablePreferenceProperty
        extends AbstractBasicLocalizablePreferenceProperty
        implements EditablePreferenceProperty
{

  /**
   *
   *  @param basicName  basic name (prefix)
   *  @param baseTag    basic i18n tag
   */
  protected AbstractBasicSimpleEditablePreferenceProperty(String basicName, String baseTag)
  {
    super(basicName, baseTag);
  }

}
