// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;

/**
 *  Description of a preference property.
 *  A preference property has a value of some kind which may be stored 
 *  to a read from a Preferences object, and it can inform listeners if
 *  this value is changed.
 * 
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface PreferenceProperty
{
  /** The property for the value of a preference property. */
  String PROPERTY_VALUE = "VALUE";

  /**
   * Read the property value from the preferences.
   * @param preferences preferences from where to read the property value
   */
  public void readFrom(Preferences preferences);

  /**
   * Store the current property value in the preferences.
   * @param preferences preferences where to store the property value
   */
  public void storeTo(Preferences preferences);

  /**
   *  Add a listener which will be called for all value changes.
   *
   *  @param listener value change listener to add
   */
  void addValueChangeListener(PropertyChangeListener listener);

  /**
   *  Remove a listener which will be called for all value changes.
   *
   *  @param listener value change listener to remove
   */
  void removeValueChangeListener(PropertyChangeListener listener);
}
