// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial products
//                     is not allowed without explicite permission.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis.statistics;

import javax.swing.*;
import javax.swing.text.html.HTMLDocument;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 *  Display statistics.
 */
public class StatisticsDialog
        extends JDialog
{
  /**
   * Creates a non-modal dialog without a title and without a specified
   * <code>Frame</code> owner.  A shared, hidden frame will be
   * set as the owner of the dialog.
   * <p/>
   * This constructor sets the component's locale property to the value
   * returned by <code>JComponent.getDefaultLocale</code>.
   *
   * @param statistics statistics to display
   * @see java.awt.GraphicsEnvironment#isHeadless
   * @see javax.swing.JComponent#getDefaultLocale
   */
  public StatisticsDialog(DumpFileStatistics statistics)
  {
    this(statistics, null, true);
  }

  /**
   * Creates a non-modal dialog without a title with the
   * specified <code>Frame</code> as its owner.  If <code>owner</code>
   * is <code>null</code>, a shared, hidden frame will be set as the
   * owner of the dialog.
   * <p/>
   * This constructor sets the component's locale property to the value
   * returned by <code>JComponent.getDefaultLocale</code>.
   *
   * @param statistics statistics to display
   * @param owner the <code>Frame</code> from which the dialog is displayed
   * @see java.awt.GraphicsEnvironment#isHeadless
   * @see javax.swing.JComponent#getDefaultLocale
   */
  public StatisticsDialog(DumpFileStatistics statistics, Frame owner)
  {
    this(statistics, owner, true);
  }

  /**
   * Creates a modal or non-modal dialog without a title and
   * with the specified owner <code>Frame</code>.  If <code>owner</code>
   * is <code>null</code>, a shared, hidden frame will be set as the
   * owner of the dialog.
   * <p/>
   * This constructor sets the component's locale property to the value
   * returned by <code>JComponent.getDefaultLocale</code>.
   *
   * @param statistics statistics to display
   * @param owner the <code>Frame</code> from which the dialog is displayed
   * @param modal true for a modal dialog, false for one that allows
   *              others windows to be active at the same time
   * @see java.awt.GraphicsEnvironment#isHeadless
   * @see javax.swing.JComponent#getDefaultLocale
   */
  public StatisticsDialog(DumpFileStatistics statistics, Frame owner, boolean modal)
  {
    super(owner, modal);
    setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    setTitle(statistics.getTitle());
    JTextPane statPane = new JTextPane();
    statPane.setContentType("text/html");
    String report = statistics.getHtmlReport();
    statPane.setText(report);
    statPane.setEditable(false);
    getContentPane().add(new JScrollPane(statPane), BorderLayout.CENTER);
    JButton button = new JButton("Ok");
    Box buttonBox = Box.createHorizontalBox();
    buttonBox.add(Box.createHorizontalGlue());
    buttonBox.add(button);
    buttonBox.add(Box.createHorizontalGlue());
    button.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        setVisible(false);
      }
    });
    buttonBox.setBorder(BorderFactory.createEmptyBorder(8, 0, 4, 0));
    pack();
  }
}
